theory question_7_1
imports Main

begin

typedecl entity
typedecl event

consts
  Girl :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Over :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Rope :: "entity ⇒ bool"
  Little :: "entity ⇒ bool"
  Yellow :: "entity ⇒ bool"

(* Explanation 1: Jumping over a yellow rope is the same as jumps rope. *)
axiomatization where
  explanation_1: "∀x y z e.
    Girl x ∧ Jumping e ∧ Agent e x ∧ Over e y ∧ Patient e y ⟷
    Jumps e ∧ Agent e x ∧ Patient e (Rope z)"

theorem hypothesis:
  (* Premise: A little girl is jumping over a yellow rope. *)
  assumes asm: "Girl x ∧ Jumping e ∧ Agent e x ∧ Over e y ∧ Patient e y ∧ Little x ∧ Yellow y"
  (* Hypothesis: A girl jumps rope. *)
  shows "∃x e. Girl x ∧ Jumps e ∧ Agent e x ∧ Patient e  Rope y "
proof -
  from asm have "Girl x ∧ Jumping e ∧ Agent e x ∧ Over e y ∧ Patient e y ∧ Little x ∧ Yellow y" by blast
  then have "Girl x ∧ Jumping e ∧ Agent e x ∧ Jumps e ∧ Patient e (Rope y)" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
