theory question_66_0

imports Main

begin

typedecl entity

consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Black :: "entity"
  Male :: "entity ⇒ bool"
  Dressed :: "entity ⇒ bool"
  Sleeves :: "entity ⇒ bool"
  RolledUp :: "entity ⇒ bool"
  ElbowHeight :: "entity ⇒ bool"
  Making :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Drink :: "entity ⇒ bool"
  MartiniGlass :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A bartender, who is a person, is wearing black. *)
axiomatization where
  explanation_1: "∃x. Bartender x ⟶ Person x ∧ Wearing x Black"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height making a drink in a martini glass. *)
  assumes asm: "Male x ∧ Bartender x ∧ Dressed x ∧ Black y ∧ All y ∧ Sleeves z ∧ RolledUp z ∧ ElbowHeight z ∧ Wearing x y ∧ Making e1 ∧ Agent e1 x ∧ Patient e1 w ∧ Drink w ∧ MartiniGlass w ∧ In w e2 ∧ e2 = x"
  (* Hypothesis: ∃x. Person(x) ∧ Black(x) *)
  shows "∃x. Person x ∧ Black x"
proof -
  from asm have "Bartender x" by auto
  then have "Person x" using explanation_1 by blast
  from asm have "Black y" by auto
  then have "Wearing x y" by auto
  then have "Person x ∧ Black y" by auto
  then show ?thesis by auto
qed

end
