theory question_46_1
imports Main

begin

typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  Fruit :: "entity ⇒ bool"
  StreetCart :: "entity ⇒ bool"
  StreetVendor :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A boy who sells fruit from a street cart is a street vendor. *)
axiomatization where
  explanation_1: "∀x y z e. Boy x ∧ Fruit y ∧ StreetCart z ⟶ (StreetVendor x ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ Has z x)"

theorem hypothesis:
  (* Premise: A boy sells fruit from a street cart *)
  assumes asm: "Boy x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ Has z x"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x" by blast
  from asm have "Sells e ∧ Agent e x ∧ Has z x" by blast
  from asm have "StreetCart z" by blast
  from asm have "Fruit y" by blast
  from asm have "Patient e y" by blast
  from asm have "StreetVendor x" using explanation_1 by blast
  show ?thesis using `Boy x` `StreetVendor x` by blast
qed

end
