theory question_36_8

imports Main

begin

typedecl entity
typedecl event

consts
  BusyCityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A busy city street implies the street has many people. *)
axiomatization where
  explanation_1: "∀x. BusyCityStreet x ⟶ (∃z. Street x ∧ Many z ∧ People z ∧ Has x z)"

theorem hypothesis:
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x. Street x ∧ Many y ∧ People y ∧ Has x y"
proof -
  from asm have "BusyCityStreet s" by blast
  then have "∃z. Street s ∧ Many z ∧ People z ∧ Has s z" using explanation_1 by blast
  then show ?thesis by blast
qed

end
