theory question_36_0
imports Main

begin

typedecl entity
typedecl event

consts
  BusyCityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  OnStreet :: "entity ⇒ entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  Walking :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation: People walking down a busy city street in the winter. *)
axiomatization where
  explanation: "∃x y z. Winter y ∧ Street x ∧ BusyCityStreet x ∧ Person z ∧ Walking z ∧ (Agent z e) ∧ OnStreet z x"

theorem hypothesis:
  (* Premise: People walking down a busy city street in the winter. *)
  assumes asm: "Winter y ∧ Street x ∧ BusyCityStreet x ∧ Person z ∧ Walking z ∧  Agent z e  ∧ OnStreet z x"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x. Street x ∧  ∀y. Person y ∧ OnStreet y x ∧ Many y "
proof -
  from asm have "BusyCityStreet x" by blast
  then have "Street x ∧ Many x" using explanation by blast
  then show ?thesis using asm by blast
qed

end
