theory question_51_0
imports Main

begin

typedecl entity
typedecl event

consts
  HighTemperature :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Combust :: "entity ⇒ bool"
  CatchFire :: "entity ⇒ bool"
  Fire :: "entity ⇒ bool"
  Causes :: "event ⇒ bool"
  Burning :: "entity ⇒ bool"
  Gives :: "event ⇒ entity ⇒ bool"
  Light :: "entity ⇒ bool"
  Heat :: "entity ⇒ bool"
  Smoke :: "entity ⇒ bool"
  Friction :: "entity ⇒ bool"
  Temperature :: "entity ⇒ bool"
  Increase :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Move :: "entity ⇒ bool"
  Against :: "entity ⇒ entity ⇒ bool"
  Road :: "entity ⇒ bool"
  Car :: "entity ⇒ bool"
  Tire :: "entity ⇒ bool"
  Speed :: "entity ⇒ bool"
  Decrease :: "entity ⇒ bool"
  Skidding :: "entity ⇒ bool"
  Motion :: "entity ⇒ bool"
  Direction :: "entity ⇒ bool"
  SourceOf :: "entity ⇒ entity ⇒ bool"
  Emits :: "event ⇒ entity ⇒ bool"
  Produces :: "event ⇒ entity ⇒ entity ⇒ bool"
  Generates :: "event ⇒ entity ⇒ entity ⇒ bool"
  ComesFrom :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: high temperatures can cause an object to combust. *)
axiomatization where
  explanation_1: "∀x. HighTemperature x ⟶ (∃e1 y. Cause e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Combust y)"

(* Explanation 2: to combust means to catch fire. *)
axiomatization where
  explanation_2: "∀x. Combust x ⟷ CatchFire x"

(* Explanation 3: fire causes burning. *)
axiomatization where
  explanation_3: "∀x. Fire x ⟶ (∃e1 y. Causes e1 ∧ Agent e1 x ∧ Burning y)"

(* Explanation 4: fire gives off light; heat; smoke. *)
axiomatization where
  explanation_4: "∀x. Fire x ⟶ (∃e1 l e2 h e3 s. Gives e1 ∧ Agent e1 x ∧ Light l ∧ Patient e1 l ∧ Gives e2 ∧ Agent e2 x ∧ Heat h ∧ Patient e2 h ∧ Gives e3 ∧ Agent e3 x ∧ Smoke s ∧ Patient e3 s)"

(* Explanation 5: friction causes the temperature of an object to increase. *)
axiomatization where
  explanation_5: "∀x. Friction x ⟶ (∃e1 y. Causes e1 ∧ Agent e1 x ∧ Temperature y ∧ Increase y)"

(* Explanation 6: friction occurs when two object's surfaces move against each other. *)
axiomatization where
  explanation_6: "∀x. Friction x ⟷ (∃y z. Object y ∧ Object z ∧ Surface y ∧ Surface z ∧ Move y ∧ Move z ∧ Against y z)"

(* Explanation 7: a road is a kind of object. *)
axiomatization where
  explanation_7: "∀x. Road x ⟶ Object x"

(* Explanation 8: a car is a kind of object. *)
axiomatization where
  explanation_8: "∀x. Car x ⟶ Object x"

(* Explanation 9: a tire is a kind of object. *)
axiomatization where
  explanation_9: "∀x. Tire x ⟶ Object x"

(* Explanation 10: a surface is a part of an object. *)
axiomatization where
  explanation_10: "∀x y. Surface x ∧ Object y ⟶ PartOf x y"

(* Explanation 11: skidding is a kind of motion. *)
axiomatization where
  explanation_11: "∀x. Skidding x ⟶ Motion x"

(* Explanation 12: skidding causes speed to decrease. *)
axiomatization where
  explanation_12: "∀x. Skidding x ⟶ (∃e1 y. Causes e1 ∧ Agent e1 x ∧ Speed y ∧ Decrease y)"

(* Explanation 13: skidding causes friction. *)
axiomatization where
  explanation_13: "∀x. Skidding x ⟶ (∃e1 y. Causes e1 ∧ Agent e1 x ∧ Friction y)"

(* Explanation 14: braking can cause skidding. *)
axiomatization where
  explanation_14: "∀x. Braking x ⟶ (∃e1 y. CanCause e1 ∧ Agent e1 x ∧ Skidding y)"

(* Explanation 15: a car moves on a road. *)
axiomatization where
  explanation_15: "∃e1 x y. Car x ∧ Road y ∧ Moves e1 ∧ Agent e1 x ∧ On e1 y"

(* Explanation 16: a tire moves against the road. *)
axiomatization where
  explanation_16: "∃e1 e2 x y. Tire x ∧ Road y ∧ Moves e1 ∧ Agent e1 x ∧ Against e2 x y"

(* Explanation 17: motion is when moves an object; something to a direction. *)
axiomatization where
  explanation_17: "∀x. Motion x ⟷ (∃e y z. Moves e ∧ Agent e y ∧ Object z ∧ Patient e z ∧ Direction z)"

(* Explanation 18: to give off means to be the source of. *)
axiomatization where
  explanation_18: "∀x. GiveOff x ⟷ SourceOf x"

(* Explanation 19: a source of something emits; produces; generates that something. *)
axiomatization where
  explanation_19: "∀x y. SourceOf x y ⟷ (Emits x y ∨ Produces x y ∨ Generates x y)"

(* Explanation 20: if something comes from something else then that something else is a source of that something. *)
axiomatization where
  explanation_20: "∀x y. ComesFrom x y ⟹ SourceOf y x"

theorem hypothesis:
  (* Premise: a car skids along the road and smoke appears to be coming from under the tires. *)
  assumes asm: "Car x ∧ Road y ∧ Skidding e1 ∧ Agent e1 x ∧ Along e1 y ∧ Appears e2 ∧ Agent e2 s ∧ Smoke s ∧ ComesFrom e3 s ∧ Agent e3 s ∧ From e3 z ∧ Under z Tire t"
  (* Hypothesis: the heat that produces the smoke is caused by friction. *)
  shows "∃e1 e2 h s x y. Heat h ∧ Produces e1 ∧ Agent e1 h ∧ Patient e1 s ∧ Smoke s ∧ Caused e2 ∧ Agent e2 f ∧ Patient e2 h ∧ Friction f"
proof -
  {
    assume "Skidding e1" "Agent e1 x" "Car x" "Road y" "Tire t"
    then obtain z where "Under z Tire t" by blast
    then obtain e2 where "Moves e2" "Agent e2 z" "Against e3 z y" by blast
    then obtain e4 where "Friction e4" "Causes e4" "Agent e4 z" "Temperature t'" "Increase t'" by blast
    then obtain e5 where "Produces e5" "Agent e5 h" "Patient e5 s" "Heat h" "Smoke s" "Caused e6" "Agent e6 f" "Patient e6 h" "Friction f" by blast
  }
  then show ?thesis using asm by blast
qed

end
