theory question_91_7

imports Main

begin

typedecl entity
typedecl event

consts
  Bears :: "entity ⇒ bool"
  Hibernate :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  EnergyConservation :: "event ⇒ entity ⇒ bool"
  Method :: "event ⇒ bool"
  Specific :: "event ⇒ bool"

(* Explanation 1: Bears hibernate during the winter as a specific method to conserve their energy. *)
axiomatization where
  explanation_1: "∀x e w. Bears x ∧ Hibernate e ∧ Agent e x ∧ Winter w ⟶ EnergyConservation e x ∧ Method e ∧ Specific e"

(* Explanation 2: Hibernation is a method used by bears to conserve energy. *)
axiomatization where
  explanation_2: "∀x e. Hibernate e ∧ Bears x ⟶ Method e ∧ EnergyConservation e x"

theorem hypothesis:
  assumes asm: "Bears x ∧ Hibernate e ∧ Agent e x"
  (* Hypothesis: Bears hibernate to conserve energy. *)
  shows "EnergyConservation e x"
proof -
  from asm have "Bears x ∧ Hibernate e ∧ Agent e x" by simp
  then have "Method e ∧ EnergyConservation e x" using explanation_2 by blast
  then show ?thesis by simp
qed

end
