theory question_83_0
imports Main

begin

typedecl entity
typedecl event

consts
  ElectricalCircuit :: "entity ⇒ bool"
  WorkingProperly :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ElectricalCurrent :: "entity ⇒ bool"
  Runs :: "event ⇒ bool"
  Computer :: "entity ⇒ bool"
  ElectricCircuit :: "entity ⇒ bool"
  Wires :: "entity ⇒ bool"
  Run :: "entity ⇒ entity ⇒ event ⇒ bool"

(* Explanation 1: when an electrical circuit is working properly, electrical current runs through that circuit *)
axiomatization where
  explanation_1: "∀x y e1 e2. ElectricalCircuit x ∧ WorkingProperly e2 ∧ Agent e2 x ⟶ (ElectricalCurrent y ∧ Runs e1 ∧ Agent e1 y ∧ Patient e1 x)"

(* Explanation 2: Currently computers run on electric circuits and wires *)
axiomatization where
  explanation_2: "∀x y z e. Computer x ∧ ElectricCircuit y ∧ Wires z ⟶ Run x y e"

theorem hypothesis:
  assumes asm: "Computer x ∧ ElectricalCircuit y ∧ WorkingProperly e2 ∧ Agent e2 y"
  (* Hypothesis: Computers run when electrical circuit is working properly. *)
  shows "∃e1. Run x y e1 ∧ Runs e1"
proof -
  {
    assume "ElectricalCircuit y ∧ WorkingProperly e2 ∧ Agent e2 y"
    then obtain e1 y' where e1: "ElectricalCurrent y' ∧ Runs e1 ∧ Agent e1 y' ∧ Patient e1 y"
      using explanation_1 by blast
    then have "Run x y e1" using explanation_2 by blast
    then have "Run x y e1 ∧ Runs e1" by simp
  }
  with asm show ?thesis by blast
qed

end
