theory question_14_0
imports Main
begin
typedecl entity
typedecl event
consts
  FissileIsotopes :: "entity ⇒ bool"
  Fission :: "event ⇒ bool"
  TakesPlace :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Divide :: "event ⇒ bool"
  IntoTwoParts :: "event ⇒ bool"
  CapableOfUndergoingFission :: "entity ⇒ bool"
  (<) :: "event ⇒ event ⇒ bool"  (* infix operator *)

(* Explanation 1: Fission takes place when a fissile isotope divides into two parts. *)
axiomatization where
  explanation_1: "∀x e1 e2. FissileIsotopes x ⟶ (∃e1 e2. Fission e1 ∧ TakesPlace e1 ∧ Agent e1 x ∧ [Divide e2 ∧ IntoTwoParts e2 ∧ e1 < e2])"

(* Explanation 2: An isotope capable of undergoing fission is called a fissile isotope. *)
axiomatization where
  explanation_2: "∀x. CapableOfUndergoingFission x ⟶ FissileIsotopes x"

theorem hypothesis:
  assumes asm: "FissileIsotopes x"
  (* Hypothesis: Fissile isotopes are capable of dividing into two parts. *)
  shows "∃e. Divide e ∧ Agent e x ∧ IntoTwoParts e"
proof -
  from asm have "FissileIsotopes x" by simp
  then obtain e1 e2 where e1: "Fission e1 ∧ TakesPlace e1 ∧ Agent e1 x" and e2: "Divide e2 ∧ IntoTwoParts e2 ∧ e1 < e2" using explanation_1 by blast
  then have "Divide e2 ∧ Agent e2 x ∧ IntoTwoParts e2" using e2 by simp
  show ?thesis using asm e2 by blast
qed

end
