theory question_97_6

imports Main

begin

typedecl entity
typedecl event

consts
  Astronomers :: "entity ⇒ bool"
  Shape :: "entity ⇒ bool"
  Galaxies :: "entity ⇒ bool"
  Classify :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Astronomers use shape to classify galaxies. *)
axiomatization where
  explanation_1: "∀x y e. Astronomers x ∧ Shape y ∧ Galaxies e ⟶ Classify e y ∧ Agent e x"

(* Premise: Just as biologists classify living things, astronomers classify galaxies. *)
assumes asm: "Just as biologists classify living things, astronomers classify galaxies."

(* Hypothesis: Shape is used to classify galaxies. *)
shows "∃x y. Shape x ∧ Galaxies y ∧ Classify y x"
proof -
  from asm have "Astronomers x" by simp
  then obtain e1 where e1: "Shape y ∧ Galaxies e ∧ Classify e y ∧ Agent e x" using explanation_1 by blast
  then have "Shape y" using e1 by simp
  show ?thesis using asm e1 `Shape y` by blast
qed

end
