theory question_65_4
imports Main

begin

typedecl entity
typedecl event

consts
  UnequalHeating :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  Formation :: "event ⇒ bool"
  GlobalWindPatterns :: "event ⇒ bool"
  Redistributing :: "event ⇒ entity ⇒ bool"
  Shape :: "event ⇒ entity ⇒ bool"

(* Explanation 1: The unequal heating of Earth's surface by the Sun results in the formation of global wind patterns, which play a crucial role in shaping global weather patterns by redistributing heat and moisture around the planet. *)
axiomatization where
  explanation_1: "∀x y e. UnequalHeating x ∧ Sun y ∧ Formation e ∧ GlobalWindPatterns e ∧ Redistributing e Heat Moisture ∧ Shape e WeatherPatterns"

theorem hypothesis:
assumes asm: "UnequalHeating x ∧ Sun y ∧ Formation e ∧ GlobalWindPatterns e"
shows "∃z. Redistributing z Heat Moisture ∧ Shape z WeatherPatterns"
proof -
  from asm have "UnequalHeating x ∧ Sun y ∧ Formation e ∧ GlobalWindPatterns e" by simp
  then obtain z where z: "Redistributing z Heat Moisture ∧ Shape z WeatherPatterns" using explanation_1 by blast
  have conclusion: "∃z. Redistributing z Heat Moisture ∧ Shape z WeatherPatterns" using z by simp
  show ?thesis using asm conclusion by auto
qed

end
