theory question_98_0

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  YoungMan :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: There is both a man jumping out of a pool. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ Jumping e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "YoungMan x ∧ Goggles y ∧ Pool z ∧ Jumping e ∧ Splashing e ∧ Agent e x ∧ Patient e z ∧ In e y"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e. Man x ∧ Jumping e ∧ Agent e x"
proof -
  from asm have "YoungMan x ∧ Goggles y ∧ Pool z" by blast
  then have "Man x" using explanation_1 by blast
  then show ?thesis using `Man x` `Jumping e` `Agent e x` by blast
qed

end
