theory question_39_1

imports Main

begin

typedecl entity
typedecl event
consts
  PlayingBasketball :: "event ⇒ bool"
  Boy :: "entity ⇒ bool"
  Basketball :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  GreenAndWhite :: "entity ⇒ bool"
  BlueAndWhite :: "entity ⇒ bool"
  Uniform :: "entity ⇒ bool"
  With :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Playing basketball means the boys are playing basketball. *)
axiomatization where
  explanation_1: "∀x y e. PlayingBasketball(e) ⟶ Boy(x) ∧ Basketball(y) ∧ Playing(e) ∧ Agent(e, x) ∧ Patient(e, y)"

(* Premise: Two boys in green and white uniforms play basketball with two boys in blue and white uniforms. *)
assumes asm: "Boy x  ∧ Basketball y  ∧ Uniform z  ∧ GreenAndWhite z  ∧ BlueAndWhite e  ∧ Playing e  ∧ Agent e  x  ∧ Patient e  y  ∧ With e  z "

(* Hypothesis: Boys are playing basketball. *)
shows "∃x y e. Boy x  ∧ Basketball y  ∧ Playing e  ∧ Agent e  x  ∧ Patient e  y "
proof -
  from asm have "Boy x" by blast
  from this have "Basketball y" using explanation_1 by blast
  from asm have "Playing e" by blast
  show ?thesis using `Boy x` `Basketball y` `Playing e` by blast
qed

end
