theory question_65_3
imports Main
begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Starts :: "event ⇒ bool"
  Flowing :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y ∧ ComesOn e3 ∧ Agent e3 y)"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity starts flowing to the light bulb in the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. Switch x ∧ SimpleSeriesCircuit y ∧ LightBulb z ∧ Closed e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (Starts e2 ∧ Flowing e3 ∧ Agent e3 x ∧ Patient e3 z)"  

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e. Electricity x ∧ LightBulb y ∧ Flowing e ∧ Agent e x ∧ Patient e y ∧ ComesOn e"
proof -
  from asm obtain e1 where e1: "Starts e1 ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 z" using explanation_2 by blast
  then have "Electricity x ∧ LightBulb z" by simp
  then obtain e2 where e2: "TurnOn e2 ∧ Agent e2 z ∧ ComesOn e2 ∧ Agent e2 z" using explanation_1 by blast
  have conclusion: "Flowing e1 ∧ Agent e1 x ∧ Patient e1 z ∧ ComesOn e2" using e1 e2 by simp
  show ?thesis using asm conclusion `Electricity x` `LightBulb z` by blast
qed

end
