theory question_65_2
imports Main
begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Flowing :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y ∧ ComesOn e3 ∧ Agent e3 y)"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity is flowing to the light bulb in the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Switch x ∧ SimpleSeriesCircuit y ∧ LightBulb z ∧ Closed e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (Flowing e2 ∧ Agent e2 x ∧ Patient e2 z)"  

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e. Electricity x ∧ LightBulb y ∧ Flowing e ∧ Agent e x ∧ Patient e y ∧ ComesOn e"
proof -
  from asm obtain z e2 where e2: "LightBulb z ∧ Flowing e2 ∧ Agent e2 x ∧ Patient e2 z" using explanation_2 by blast
  then obtain e3 where e3: "ComesOn e3 ∧ Agent e3 z" using explanation_1 by blast
  have conclusion: "Flowing e2 ∧ Agent e2 x ∧ Patient e2 z ∧ ComesOn e3" using e2 e3 by simp
  show ?thesis using asm conclusion `Electricity x` `LightBulb z` by blast
qed

end
