theory question_54_0

imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  TennisBall :: "entity ⇒ bool"
  Strikes :: "event ⇒ bool"
  Playing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Tennis :: "entity ⇒ bool"
  RedAndBlack :: "entity ⇒ bool"
  AboutToStrike :: "event ⇒ bool"

(* Explanation 1: The man strikes the tennis ball because he is playing tennis. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Man x ∧ TennisBall y ∧ Strikes e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Playing e2 ∧ Agent e2 x ∧ Patient e2 y"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ RedAndBlack x ∧ TennisBall y ∧ AboutToStrike e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x y e. Man x ∧ Tennis y ∧ Playing e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Man x ∧ TennisBall y ∧ AboutToStrike e ∧ Agent e x ∧ Patient e y" by blast
  then have "Man x ∧ Tennis y ∧ Playing e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
