theory question_80_8
imports Main
begin

typedecl entity
typedecl event

consts
  Copper :: "entity ⇒ bool"
  Metal :: "entity ⇒ bool"
  Materials :: "entity ⇒ bool"
  ElectricalConductors :: "entity ⇒ bool"
  Conducts :: "event ⇒ bool"
  Material :: "entity ⇒ bool"
  Electricity :: "event ⇒ bool"

(* Explanation 1: Copper is a specific type of metal. *)
axiomatization where
  explanation_1: "∀x. Copper x ⟶ Metal x"

(* Explanation 2: Some materials are electrical conductors. *)
axiomatization where
  explanation_2: "∃x. Materials x ∧ ElectricalConductors x"

(* Explanation 3: Copper is a material that conducts electricity. *)
axiomatization where
  explanation_3: "∃x. Copper x ⟶ (∃e. Conducts e ∧ Material x ∧ Electricity e)"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Materials x ∧ ElectricalConductors x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x ∧  Conducts e ∧ Material x ∧ Electricity e "
proof -
  from asm have "Materials x" and "ElectricalConductors x" by auto
  then obtain e where e: "Conducts e ∧ Material x ∧ Electricity e" using explanation_2 by blast
  then have "Copper x" using explanation_3 by blast
  show ?thesis using e `Copper x` by blast
qed

end
