theory question_68_0
imports Main

begin

typedecl entity
typedecl event

consts
  Evolution :: "entity ⇒ bool"
  Process :: "entity ⇒ bool"
  NaturalSelection :: "event ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Called :: "event ⇒ entity ⇒ bool"
  Electing :: "entity ⇒ bool"
  Survive :: "entity ⇒ bool"

(* Explanation 1: Evolution occurs by a process called natural selection. *)
axiomatization where
  explanation_1: "∀x y e. Evolution x ∧ Process y ∧ NaturalSelection e ∧ Occurs e ∧ Agent e x ∧ Patient e y ∧ Called e y"

(* Explanation 2: Evolution is about electing to survive. *)
axiomatization where
  explanation_2: "∀x y. Evolution x ∧ Electing y ⟶ Survive x"

theorem hypothesis:
  assumes asm: "NaturalSelection x ∧ Them y"
  (* Hypothesis: Natural selection helps them survive. *)
  shows "∃x y e. NaturalSelection x ∧ Them y ∧ Helps e ∧ Agent e x ∧ Patient e y ∧ Survive y"
proof -
  from asm have "NaturalSelection x" and "Them y" by auto
  then obtain e where e: "Occurs e ∧ Agent e x ∧ Patient e y ∧ Called e y" using explanation_1 by blast
  then have "Evolution x" and "Process y" using e by auto
  then have "Electing y" using explanation_2 by blast
  have conclusion: "Occurs e ∧ Agent e x ∧ Patient e y" using e by auto
  show ?thesis using `NaturalSelection x` `Them y` conclusion `Survive y` by blast
qed

end
