theory question_17_1

imports Main

begin

typedecl entity
typedecl event

consts
  Consumers :: "entity ⇒ bool"
  TrophicLevel :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"
  Plants :: "entity ⇒ bool"
  Producers :: "entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"

(* Explanation 1: Many consumers feed at more than one trophic level. *)
axiomatization where
  explanation_1: "∀x e. Consumers x ⟶ (∃y z. TrophicLevel y ∧ TrophicLevel z ∧ Feed e ∧ Agent e x ∧ At e y ∧ At e z)"

(* Explanation 2: Plants are producers are consumers are omnivores. *)
axiomatization where
  explanation_2: "∀x. Plants x ⟶ (Producers x ∧ Consumers x ∧ Omnivores x)"

theorem hypothesis:
  assumes asm: "Omnivores x"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x e. Omnivores x ∧  TrophicLevel y ∧ TrophicLevel z ∧ Feed e ∧ Agent e x ∧ At e y ∧ At e z "
proof -
  from asm have "Omnivores x" by simp
  then obtain e y z where e: "TrophicLevel y ∧ TrophicLevel z ∧ Feed e ∧ Agent e x ∧ At e y ∧ At e z" using explanation_1 by blast
  have conclusion: "TrophicLevel y ∧ TrophicLevel z ∧ Feed e ∧ Agent e x ∧ At e y ∧ At e z" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
