theory question_89_5

imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  RecreationalActivity :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Recognized :: "entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Mountain biking during autumn is a widely recognized recreational activity. *)
axiomatization where
  explanation_1: "∀x y z. MountainBiking x ∧ Autumn y ∧ RecreationalActivity z ⟶ (In x y ∧ Recognized z)"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking x ∧ Forest y ∧ EarlyFall z ∧ In x y ∧ In x z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling x ∧ Woods y ∧ Autumn z ∧ In x y ∧ In x z"
proof -
  from asm have "MountainBiking x ∧ Autumn z" by blast
  then have "Bicycling x ∧ Woods y ∧ Autumn z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
