theory question_67_0
imports Main

begin
typedecl entity
typedecl event

consts
  BoatTour :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  On :: "entity ⇒ event ⇒ bool"
  Older :: "entity ⇒ bool"
  RiverBoatTour :: "entity ⇒ bool"
  Sitting :: "event ⇒ bool"
  Together :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: In order to take a boat tour, the two males must be on a boat. *)
axiomatization where
  explanation_1: "∀x y e. BoatTour x ∧ Male x ∧ Male y ⟶ On x e ∧ On y e"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "Male x ∧ Male y ∧ Older x ∧ Older y ∧ RiverBoatTour e ∧ Sitting e ∧ Together x y"
  (* Hypothesis: Two males sitting together on a boat. *)
  shows "∃x y e. Male x ∧ Male y ∧ BoatTour e ∧ Sitting e ∧ Together x y ∧ On x e ∧ On y e"
proof -
  from asm have "Male x ∧ Male y ∧ RiverBoatTour e ∧ Sitting e ∧ Together x y" by blast
  then have "BoatTour e ∧ On x e ∧ On y e" using explanation_1 by blast
  then show ?thesis using `Male x` `Male y` by blast
qed

end
