theory question_40_3
imports Main

begin
typedecl entity
typedecl event

consts
  PlayingInWater :: "event ⇒ bool"
  Person :: "entity ⇒ bool"
  InContactWithWater :: "event ⇒ bool"
  GettingWet :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  YoungBoy :: "entity ⇒ bool"
  PlayingInBubble :: "entity ⇒ bool"

(* Explanation 1: Playing in water causes the person to be in contact with water. *)
axiomatization where
  explanation_1: "∀x e1 e2. PlayingInWater e1 ∧ Person x ∧ Agent e1 x ⟶ (InContactWithWater e2 ∧ Agent e2 x)"

(* Explanation 2: Being in contact with water leads to the person getting wet. *)
axiomatization where
  explanation_2: "∀x e1 e2. InContactWithWater e1 ∧ Person x ∧ Agent e1 x ⟶ (GettingWet e2 ∧ Agent e2 x)"

theorem hypothesis:
  (* Premise: A young boy playing in a bubble playing in water. *)
  assumes asm: "YoungBoy x ∧ PlayingInBubble y ∧ PlayingInWater z ∧ Agent e x ∧ Agent e y ∧ Agent e z"
  (* Hypothesis: A person is getting wet. *)
  shows "∃x e. Person x ∧ GettingWet e ∧ Agent e x"
proof -
  from asm have "YoungBoy x ∧ PlayingInWater z ∧ Agent e x" by blast
  from this and explanation_1 have "InContactWithWater e' ∧ Agent e' x" by blast
  from this and explanation_2 have "GettingWet e'' ∧ Agent e'' x" by blast
  then show ?thesis using `Person x` `GettingWet e''` by blast
qed

end
