import os


def compute_bleu(paths):
    for path in paths:
        print('path = ', path)
        os.system(f"python metric.py --path {path} --bleu --all")
        print('=' * 100)


def compute_bertscore(paths, max=True):
    for path in paths:
        print('path = ', path)
        if max:
            os.system(f"python metric.py --path {path} --recall --max")
        else:
            os.system(f"python metric.py --path {path} --recall")
        print('=' * 100)


def get_dir_files(dir):
    files = os.listdir(dir)
    res = []
    for f in files:
        res.append(os.path.join(dir, f))
    print(res)
    return res


if __name__ == '__main__':
    # results_path = [
    #         '../result/gpt2_baseline_bte_onecard_1.0.json',
    #         '../result/gpt2_baseline_tbe_onecard_1.0.json',
    #         '../result/plan_write_out.json',
    #         '../result/plan_ahead_bte_onecard_1.0.json',
    #         '../result/baseline_dynamic_outline_version_num0_sent1.json',
    #         '../result/kg_combine4_outline_onecard_version5_1.0.json',
    #         '../result/kg_combine4_reweight_outline_onecard_version17_1.0.json',
    #         '../result/kg_combine4_reweight_outline_target_onecard_version12_1.0.json'
    #     ]
    # results_path = [
    #     '../result/kg_combine4_outline_onecard_version5_1.0.json'
    # ]
    results_path = [
        '../result/final/kg_combine4_outline_persona_onecard_version2_1.0.json',
        '../result/final/kg_combine4_reweight_outline_target_onecard_version14_1.0.json',
        '../result/final/baseline_outline_target_onecard_version2_1.0.json',
        '../result/final/gpt2_baseline_bte_onecard_1.0_persona.json',
        '../result/final/plan_ahead_bte_onecard_1.0.json',
        '../result/final/gpt2_baseline_tbe_onecard_1.0_persona.json',
        '../result/final/plan_write_out.json'
    ]
    results_path = [
        '../result/baseline_outline_onecard_version0_1.0.json',
        '../result/kg_combine4_reweight_outline_target_onecard_version12_1.0.json',
        '../result/kg_combine4_reweight_outline_target_onecard_version16_1.0.json',
        '../result/kg_combine4_outline_persona_onecard_version4_1.0.json'
        '../result/kg_combine4_reweight_outline_onecard_version18_1.0.json',
        '../result/kg_combine4_outline_onecard_version108_1.0.json'
    ]
    results_path = [
        '../result/plan_ahead_bte_onecard_version_num14_1.0.json',
        '../result/kg_combine4_reweight_outline_onecard_version20_1.0.json',
        '../result/kg_combine4_reweight_outline_onecard_version21_1.0.json',
        '../result/kg_combine4_outline_onecard_version111_1.0.json'
    ]
    results_path = [
        '../result/kg_combine4_reweight_outline_onecard_version18_1.0.json'
    ]
    results_path = [
        '../result/gpt2_baseline_bte_nopretrain_onecard_1.0_persona.json',
        # '../result/kg_combine4_reweight_outline_onecard_version22_1.0.json',
        '../result/kg_combine4_outline_onecard_version113_1.0.json'
    ]
    results_path = [
        '../result/gpt2_baseline_bte_nopretrain_version3_1.0_persona.json',
        '../result/gpt2_baseline_bte_onecard_1.0_persona.json',
    ]
    results_path = [
        '../result/gpt2_wo_knowledge_onecard_version3_1.0.json'
    ]
    results_path = get_dir_files('../result/final')
    results_path = [
        # '../result/gpt2_bte_outline_knowledge_onecard_version3_1.0.json',
        # '../result/gpt2_baseline_bte_version5_1.0_persona.json',
        '../result/gpt2_baseline_bte_onecard.json.gz'
    ]
    results_path = [
        # '../result/gpt2_baseline_bte_version6_1.0_persona.json',
        '../result/gpt2_baseline_bte_nopretrain_version3_1.0_persona.json',
    ]
    results_path = [
        '../result/gpt2_baseline_tbe_onecard_1.0.json'
    ]
    # compute_bleu(results_path)
    compute_bertscore(paths=results_path, max=True)
    print('max True finished! max false now!')
    print('!'*40)
