import json

MAP = {
    "qa": "qa",
    "classification": "cls",
    "other": "other",
    "conditional generation": "cg"
}

def add_element(d, name, category, subcategory):
    if category not in d:
        d[category] = {}
    
    sub_d = d[category]

    if subcategory not in sub_d:
        sub_d[subcategory] = []

    sub_d[subcategory].append(name)

def main():
    with open("ontology.csv") as fin:
        lines = fin.readlines()

    d = {}

    for line in lines[1:]:
        elements = line.split(",")
        name = elements[0]
        category = elements[2]
        subcategory = elements[3]
        if subcategory == "":
            subcategory = "n/a"
        if elements[0] == "":
            continue

        add_element(d, name, category, subcategory)
        

    
    for k,v in d.items():
        for k1, v1 in v.items():
            v[k1] = sorted(v1)

    print(json.dumps(d, sort_keys=True))

    with open("ontology.json", "w") as fout:
        json.dump(d, fout, indent=4, sort_keys=True)


if __name__ == "__main__":
    main()