export CUDA_VISIBLE_DEVICES=0
export TASK=RTE

export MODEL_DIR=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/transformers/examples/text-classification/models/${TASK}_output_softmax_layernorm_approximation_no_pooler
# export MODEL_PATH=${MODEL_DIR}/pytorch_model.bin
export MODEL_PATH=/home/LAB/chenty/workspace/public_models/bert-tiny/pytorch_model.bin
export CONFIG_PATH=/home/LAB/chenty/workspace/public_models/bert-tiny/bert_config_relu.json
export VOCAB_PATH=/home/LAB/chenty/workspace/public_models/bert-tiny/vocab.txt
export DATA_DIR=/home/LAB/chenty/workspace/public_dataset/GLUE/${TASK}
export OUTPUT_DIR=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/unilm2-he/models/${TASK}_softmax

python run_classifier.py \
  --model_type unilm --task_name ${TASK} --tokenizer_name unilm2-base-uncased --model_name_or_path ${MODEL_PATH} \
  --config_name ${CONFIG_PATH} --data_dir ${DATA_DIR} \
  --do_lower_case --convert_checkpoint_to_unilm \
  --do_train --do_eval --evaluate_during_training --logging_steps 100 --output_dir ${OUTPUT_DIR} --max_grad_norm 0 --max_seq_length 128 \
  --learning_rate 3e-4 --num_training_epochs 10 --weight_decay 0.1 --warmup_ratio 0.1 --per_gpu_train_batch_size 8 \
  --per_gpu_eval_batch_size 128 \
  --overwrite_output_dir \
  --seed 42 \
  --softmax_approximation
  # --softmax_approximation --app_ln_layer --app_ln_layer\
  # --convert_checkpoint_to_unilm \