import pickle
import numpy as np
import xlrd
import xlwt
import pymysql
import gensim
#打开excel
from sklearn import preprocessing

import xlsxwriter as xw


df=open('../data/cfcount2cfid_dic.pkl','rb')#2912
index2id = pickle.load(df)
df.close()

df=open('../data/cfcount2character_dic.pkl','rb')#2912
index2character = pickle.load(df)
df.close()

index2ccharacter={}
index2cid={}
cid2id={}


def readJia2():

    wb = xlrd.open_workbook('../data/20210520_oracle-radical.xlsx')
    # 按工作簿定位工作表
    sh = wb.sheet_by_name('甲骨文-部件对应表')
    count=0
    ccount=0
    for i in range(sh.nrows):
        if i == 0:
            continue
        # print(sh.row_values(i))
        li = sh.row_values(i)
        id = li[0]
        id=id.split("_")[3]+id.split("_")[4]
        cha=li[1]

        pp=li[3]
        if "," in pp:
            pp=pp.split(",")
        else:
            pp=[pp]

        if id[:-1] not in cid2id.keys():
            cid2id[id[:-1]]=[id]
            index2cid[ccount] = id[:-1]
            index2ccharacter[ccount] = cha
            ccount=ccount+1
        else:
            cid2id[id[:-1]].append(id)
        #print(id +" "+pp[0])


def similarityRank(num,temp):
    #num：取排名最高的前几名

    max_value = []
    max_index = []
    for k in range(num):
        index_max = np.argmax(temp, axis=1)  # 其中，axis=1表示按行计算
        #print(index_max)
        max = temp[range(temp.shape[0]), index_max]
        #print(max)
        temp[range(temp.shape[0]), index_max] = -1
        max_value.append(max)
        max_index.append(index_max)
    max_index=np.array(max_index)
    max_value = np.array(max_value)
    return max_value.T, max_index.T


def showoutput(max_index,max_value,topk,level=1):
    cid2mappings={}
    c2mappings={}
    if level==0:
        for n in range(len(max_index)):  # 每一行，每一个字
            cid2mappings[index2id[n]] = []
            c2mappings[index2character[n]] = []
            for k in range(topk):
                index = max_index[n][k]
                cid2mappings[index2id[n]].append((index2id[index], max_value[n][k]))
                c2mappings[index2character[n]].append((index2character[index], max_value[n][k]))
    else:
        for n in range(len(max_index)):  # 每一行，每一个字
            cid2mappings[index2cid[n]] = []
            c2mappings[index2ccharacter[n]] = []
            for k in range(topk):
                index = max_index[n][k]
                cid2mappings[index2cid[n]].append((index2cid[index], max_value[n][k]))
                c2mappings[index2ccharacter[n]].append((index2ccharacter[index], max_value[n][k]))
    return cid2mappings,c2mappings





def getLCSRnumsimi(num=20):
    cpair2LCSsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy')
    cpair2LCSsimi_np1=cpair2LCSsimi_np
    max_value, max_index = similarityRank(num, cpair2LCSsimi_np)
    cid2mappings, c2mappings = showoutput(max_index, max_value, num)
    return cid2mappings, c2mappings,cpair2LCSsimi_np1

def getNetsimi(num=20):
    cpair2Netsimi_np = np.load('../data/results/jia_graph_simi_np.npy')
    max_value, max_index = similarityRank(num, cpair2Netsimi_np)
    cid2mappings, c2mappings = showoutput(max_index, max_value, num)
    return cid2mappings, c2mappings,cpair2Netsimi_np



def getFigureFiltersimi(num=20):
    cpair2Figuresimi_np = np.load('../data/results/jia_pic_simi_np.npy')
    max_value, max_index = similarityRank(num, cpair2Figuresimi_np)
    cid2mappings, c2mappings = showoutput(max_index, max_value, num)
    return cid2mappings, c2mappings,cpair2Figuresimi_np



def getmixLCSNetsimi(num=20,v1=0.5,v2=0.5):
    cpair2LCSsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy')
    cpair2Netsimi_np = np.load('../data/results/jia_graph_simi_np.npy')
    similarity_np = v1 * cpair2LCSsimi_np+v2 * cpair2Netsimi_np
    max_value, max_index = similarityRank(num, similarity_np)
    cid2mappings, c2mappings = showoutput(max_index, max_value, num)
    return cid2mappings, c2mappings,similarity_np


def getmixLCSFiguresimi(num=20,v1=0.5,v2=0.5):
    cpair2LCSsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy')
    cpair2Figuresimi_np = np.load('../data/results/jia_pic_simi_np.npy')
    similarity_np = v1 * cpair2LCSsimi_np+v2 * cpair2Figuresimi_np
    max_value, max_index = similarityRank(num, similarity_np)
    cid2mappings, c2mappings = showoutput(max_index, max_value, num)
    return cid2mappings, c2mappings,similarity_np

def getmixLCSNetFiguresimi(num=20,v1=0.4,v2=0.4,v3=0.3):
    cpair2LCSsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy')
    cpair2Netsimi_np = np.load('../data/results/jia_graph_simi_np.npy')
    cpair2Figuresimi_np = np.load('../data/results/jia_pic_simi_np.npy')
    similarity_np = v1 * cpair2LCSsimi_np+v2*cpair2Netsimi_np+v3 * cpair2Figuresimi_np
    max_value, max_index = similarityRank(num, similarity_np)
    cid2mappings, c2mappings = showoutput(max_index, max_value, num)
    return cid2mappings, c2mappings,similarity_np


def wirte2excel(path,type=123,topk=30):
    cpair2LCSsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy')
    cpair2Netsimi_np = np.load('../data/results/jia_graph_simi_np.npy')
    cpair2Figuresimi_np = np.load('../data/results/jia_pic_simi_np.npy')
    if type==1:
        similarity_np=cpair2LCSsimi_np
    elif type==2:
        similarity_np = cpair2Figuresimi_np
    elif type==3:
        similarity_np = cpair2Netsimi_np
    elif type==12:
        similarity_np = 0.5 * cpair2LCSsimi_np+0.5 * cpair2Figuresimi_np
    elif type == 13:
        similarity_np = 0.5 * cpair2LCSsimi_np + 0.5 * cpair2Netsimi_np
    else:
        similarity_np = 0.4 * cpair2LCSsimi_np+0.3*cpair2Netsimi_np+0.4 * cpair2Figuresimi_np

    contexts=[]
    max_value, max_index=similarityRank(topk, similarity_np)
    for n in range(len(max_index)):#每一行，每一个字
        infos=[]
        cfid=index2cid[n]
        #cfid=cfid[:-1]+"_"+cfid[-1]
        cf=index2ccharacter[n]
        for k in range(topk):
            index=max_index[n][k]
            mcfid=index2cid[index]
            #mcfid = mcfid[:-1] + "_" + mcfid[-1]
            mcf = index2ccharacter[index]
            mvalue=max_value[n][k]
            mvalue=round(mvalue,4)
            info=str(k+1)+"_"+mcfid+"_"+mcf+"_"+str(mvalue)
            infos.append(info)
        contexts.append([cfid,cf,"; ".join(infos)])


    workbook = xlwt.Workbook(encoding='utf-8')  # 写入excel文件
    sheet = workbook.add_sheet('Sheet1', cell_overwrite_ok=True)  # 新增一个sheet工作表

    for i in range(len(contexts)):  # 写入3行数据
        for j in range(3):  # 写入3列数据
            sheet.write(i, j, contexts[i][j])

    workbook.save(path)  # 保存




readJia2()

cid2mappings3, c2mappings3,similarity_np3=getNetsimi(num=50)
cid2mappings5, c2mappings5,similarity_np5=getLCSRnumsimi(num=200)
cid2mappings4, c2mappings4,similarity_np4=getFigureFiltersimi(num=50)
cid2mappings12, c2mappings12,similarity_np12=getmixLCSFiguresimi(num=50,v1=0.5,v2=0.5)
cid2mappings13, c2mappings13,similarity_np13=getmixLCSNetsimi(num=50,v1=0.5,v2=0.5)
cid2mappings123, c2mappings123,similarity_np123=getmixLCSNetFiguresimi(num=100,v1=0.4,v2=0.3,v3=0.4)



excelpath1 =('../data/results/jia_RLCSsim_500.xls')
excelpath2 =('../data/results/jia_picsim_500.xls')
excelpath3 =('../data/results/jia_Graphsim_500.xls')
excelpath12 =('../data/results/jia_RLCS_picsim_500.xls')
excelpath13 =('../data/results/jia_RLCS_Graphsim_500.xls')
excelpath123 = '../data/results/jia_RLCS_Pic_Graphsim_500.xls'


# wirte2excel(excelpath1,1,topk=500)
# wirte2excel(excelpath2,2,topk=500)
# wirte2excel(excelpath12,12,topk=500)
# wirte2excel(excelpath3,3,topk=500)
# wirte2excel(excelpath13,13,topk=500)
# wirte2excel(excelpath123,123,topk=500)



c1="木"
c2="宿"
c3="月"
c4="犬"
c5="降"
c6="鹿凵"
c7="鼎"
c8="刀"
c9="降"
c10="牢"


print("-------------------------------------------")
print("RLCS")
print(c2mappings5[c1])
print(c2mappings5[c2])
print(c2mappings5[c3])
print(c2mappings5[c4])
print(c2mappings5[c5])
print(c2mappings5[c6])
print(c2mappings5[c7])
print(c2mappings5[c8])
print(c2mappings5[c9])
print(c2mappings5[c10])

print("-------------------------------------------")
print("Pic")
print(c2mappings4[c1])
print(c2mappings4[c2])
print(c2mappings4[c3])
print(c2mappings4[c4])
print(c2mappings4[c5])
print(c2mappings4[c6])
print(c2mappings4[c7])
print(c2mappings4[c8])
print(c2mappings4[c9])
print(c2mappings4[c10])
print("-------------------------------------------")
print("Graph")
print(c2mappings3[c1])
print(c2mappings3[c2])
print(c2mappings3[c3])
print(c2mappings3[c4])
print(c2mappings3[c5])
print(c2mappings3[c6])
print(c2mappings3[c7])
print(c2mappings3[c8])
print(c2mappings3[c9])
print(c2mappings3[c10])
print("-------------------------------------------")
print("RLCS+Pic")
print(c2mappings12[c1])
print(c2mappings12[c2])
print(c2mappings12[c3])
print(c2mappings12[c4])
print(c2mappings12[c5])
print(c2mappings12[c6])
print(c2mappings12[c7])
print(c2mappings12[c8])
print(c2mappings12[c9])
print(c2mappings12[c10])
print("-------------------------------------------")
print("RLCS+Graph")
print(c2mappings13[c1])
print(c2mappings13[c2])
print(c2mappings13[c3])
print(c2mappings13[c4])
print(c2mappings13[c5])
print(c2mappings13[c6])
print(c2mappings13[c7])
print(c2mappings13[c8])
print(c2mappings13[c9])
print(c2mappings13[c10])
print("-------------------------------------------")
print("RLCS+Graph+Pic")
print(c2mappings123[c1])
print(c2mappings123[c2])
print(c2mappings123[c3])
print(c2mappings123[c4])
print(c2mappings123[c5])
print(c2mappings123[c6])
print(c2mappings123[c7])
print(c2mappings123[c8])
print(c2mappings123[c9])
print(c2mappings123[c10])



