seed_list=(1 2 3 4)
learning_rate_list=("4e-5" "5e-5")

train_file="/path/to/nli_for_simcse.csv"
eval_file="/path/to/eval/directory"

for seed in ${seed_list[@]}; do
for learning_rate in ${learning_rate_list[@]}; do
  CUDA_VISIBLE_DEVICES=2 PYTHONPATH=src python \
    src/scripts/run_train_sts.py \
    --model_name_or_path roberta-base \
    --loss_type clrcmd \
    --train_file ${train_file} \
    --eval_file ${eval_file} \
    --dataloader_drop_last \
    --evaluation_strategy steps \
    --eval_steps 250 \
    --metric_for_best_model stsb_spearman \
    --load_best_model_at_end \
    --mlp_only_train \
    --temp 0.05 \
    --do_train \
    --do_eval \
    --fp16 \
    --num_train_epochs 3 \
    --save_total_limit 1 \
    --per_device_train_batch_size 128 \
    --per_device_eval_batch_size 128 \
    --gradient_accumulation_steps 1 \
    --learning_rate ${learning_rate} \
    --hidden_dropout_prob 0.1 \
    --seed ${seed}
done
done
done
