def default_base_parameters():
    params = {}
    params["hidden_size"]=512
    params["filter_size"]=2048
    params["num_heads"]=4
    params["num_encoder_layers"]=6
    params["num_decoder_layers"]=6
    params["attention_dropout"]=0.1
    params["residual_dropout"]=0.1
    params["relu_dropout"]=0.1
    params["layer_preproc"]="none"
    params["layer_postproc"]="layer_norm"
    params["shared_embedding_and_softmax_weights"]=False
    params["shared_source_target_embedding"]=False
    params["keep_checkpoint_max"]=100
    params['train_max_len']=100
    params["confidence"]=0.9
    params["optimizer"]="adam"
    params["learning_rate_decay"]="linear_warmup_rsqrt_decay"
    params["initializer"]="uniform_unit_scaling"
    params["initializer_scale"]=0.1
    params["learning_rate"]=1.0
    params["learning_rate_boundaries"]=[0]
    params["learning_rate_values"]=[0.0]
    params["train_batch_size_tokens"]=4096
    params["update_cycle"]=1
    params["warmup_steps"] = 4000
    params["adam_beta1"]=0.9
    params["adam_beta2"]=0.98
    params["adam_epsilon"]=1e-9
    params["gradient_clip_norm"]=0.0
    params["scale_l1"]=0.0
    params["scale_l2"]=0.0
    
    params["beam_size"]=4
    params["lp_rate"]=0.6
    params["batch_size_examples"]=32
    params["max_len"]=100
    params['seed']=1234
    
    return params


def wmt14_ende_parameters():
    params = default_iwslt_parameters()
    
    params["train_src"]='./workdir/train/train.en'
    params["train_trg"]='./workdir/train/train.de'
    params["dev_src"]='./workdir/dev/dev.src'
    params["dev_trg"]='./workdir/dev/dev.tgt'
    params["vocab_src"]='./workdir/vocab/src.vocab.txt'
    params["vocab_trg"]='./workdir/vocab/tgt.vocab.txt'
    params["model_dir"]='./workdir/model/'
    params["src_vocab_size"] = 37006
    params["trg_vocab_size"] = 37006
    
    params["num_gpus"] = 2
    params["epoch"] = 100
    params["save_per_checkpoints_steps"]=5000
    params["update_cycle"]=2
    params["train_batch_size_tokens"]=8192
    params["warmup_steps"] = 4000
    params["conv_filter_sizes"]=[3,4,5]
    params["num_conv_filters"]=128
    
    params["layer_preproc"]="none"
    params["layer_postproc"]="layer_norm"
    params["shared_source_target_embedding"]=True
    params["shared_embedding_and_softmax_weights"]=True
    return params
