import os

# run the following command in terminal

# python run_glue.py \
#   --model_name_or_path bert-base-cased \
#   --task_name $TASK_NAME \
#   --do_train \
#   --do_eval \
#   --max_seq_length 128 \
#   --per_device_train_batch_size 32 \
#   --learning_rate 2e-5 \
#   --num_train_epochs 3 \
#   --output_dir /tmp/$TASK_NAME/

import subprocess
import os

cmd1 = 'export TASK_NAME=mrpc'

p1 = subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)
out1, err1 = p1.communicate() 

models = []
model_names = []
base_name = "yanaiela/roberta-base-epoch_"
for i in range(0,84):
    name = base_name + str(i)
    model_names.append("roberta_base_epoch_" + str(i))
    models.append(name)

for model in models:
    if not os.path.exists(f"./Probing_Experiments/RoBERTa_Intermediate/glue_results/{model_names[models.index(model)]}"):
        os.mkdir(f"./Probing_Experiments/RoBERTa_Intermediate/glue_results/{model_names[models.index(model)]}")
    cmd2 = f'python run_glue.py \
        --model_name_or_path {model} \
        --task_name $TASK_NAME \
        --do_train \
        --do_eval \
        --max_seq_length 128 \
        --per_device_train_batch_size 32 \
        --learning_rate 2e-5 \
        --num_train_epochs 3 \
        --output_dir ./Probing_Experiments/RoBERTa_Intermediate/glue_results/{model_names[models.index(model)]}'
    p2 = subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)
    out2, err2 = p2.communicate()


