#!/usr/bin/env bash
#echo "-------------------------- lr = 0.00001---------------------------------------------------------------------------------------------------"
#python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline" -model "lstm" -update_every 128 -agent "REINFORCE" -K_epochs 20 -eps_clip 0.02 -lr 0.00001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 50000 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1 -policy_path "output/SL_LSTM_32_64_vqa/model.pt" -device_id 0
echo "-------------------------- lr = 0.00005---------------------------------------------------------------------------------------------------"
python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline" -model "lstm" -update_every 128 -agent "REINFORCE" -K_epochs 20 -eps_clip 0.02 -lr 0.00005 -word_emb_size 32 -hidden_size 64 -num_episodes_train 50000 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1 -policy_path "output/SL_LSTM_32_64_vqa/model.pt" -device_id 0
echo "-------------------------- lr = 0.00001 PPO---------------------------------------------------------------------------------------------------"
python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.00001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 50000 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1 -policy_path "output/SL_LSTM_32_64_vqa/model.pt" -device_id 0
echo "-------------------------- lr = 0.00001 PPO & sgd---------------------------------------------------------------------------------------------------"
python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.00001 -optimizer "sgd" -word_emb_size 32 -hidden_size 64 -num_episodes_train 50000 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1 -policy_path "output/SL_LSTM_32_64_vqa/model.pt" -device_id 0
echo "-------------------------- scratch---------------------------------------------------------------------------------------------------"
#python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 50000 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1  -p_th 0.05 -device_id 0
python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline/SL" -model "lstm" -update_every 128 -agent "REINFORCE" -K_epochs 20 -eps_clip 0.02 -lr 0.00005 -word_emb_size 32 -hidden_size 64 -num_episodes_train 0 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1 -policy_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline/clevr_vqa_PPO_answ-uniform_scratch_adam_0.001_ent0.01_epsclip0.02_graclipNone/20210223-120606/checkpoints/model.pt" -device_id 1
echo "-------------------------- SL Baseline ---------------------------------------------------------------------------------------------------"
python src/scripts/run.py -max_len 20 -data_path "data" -out_path "output/RL/2021_exp_clvr_vqa_20000img_len20/baseline/SL" -model "lstm" -update_every 128 -agent "REINFORCE" -K_epochs 20 -eps_clip 0.02 -lr 0.00005 -word_emb_size 32 -hidden_size 64 -num_episodes_train 0 -debug "0,20000" -lm_path "output/lm_model/model.pt" -reward "vqa" -reward_path "output/vqa_model_film/model.pt" -condition_answer "after_fusion" -num_episodes_test 5000 -reward_vocab "data/closure_vocab.json" -mask_answers 1 -policy_path "output/SL_LSTM_32_64_vqa/model.pt" -device_id 0
