# e2e-zpcoref

端到端中文零指代消解

## 目录结构

+ data/: 数据目录，用于存放 ontonotes、train/test/val、checkpoint
+ config.py: 配置文件
+ train.py: 训练文件
+ test.py: 测试文件
+ tools.py: 工具文件
+ model.py: 模型文件
+ Encoder.py: 编码文件
+ ontonotes_preprocessor.py: ontonotes数据集处理文件


## 数据集收集和处理

### 使用 ontonotes 数据集

1. 从 LDC 网站下载 ontonotes 数据集，若做中文零指代，将 config.py 中的 "ontonotes_root_dir" 修改为 "/path/to/ontonotes/data/files/data/chinese/annotations"
2. 运行命令 ```python ontonotes_preprocessor.py```
3. 若没出现问题，则 data/ 下会生成 train.json/test.json/val.json 三个文件

### 使用自己的数据

将数据根据需要分割成 train.json/test.json/val.json

三个json文件的格式为：每行代表一个文档，每行都是一个json对象，json对象具体内容为：（注：此处为了美观将json对象格式化为多行，在真实文件中需为1行）

```
{
    "doc_key": "文档的地址", 
    "sentences": [["token1", "token2", ...], ...],
    "clusters": [[[sloc1, eloc1], [sloc2, eloc2], ...], ...],
    "speaker_ids" [["speaker#1", ...], ...]
    "sentence_map": [[0, 0, 0, ..., 3, 3, 3], ...],
    "subtoken_map": [[0, 0, 1, 2, 3, ...], ...]
}
```

说明：context可使用字符级表示或者词级表示；clusters 是文档中所有指代链的集合，由若干指代链组成，一个指代链由若干个指代词（包括零指代）或先行语组成，指代词/先行语使用位置和token个数表示：```[在文档中的token位置，token个数]```，对于零指代，其在文档中的位置为其后面字符的位置，token个数为 0。token在字符级表示时为一个字符，在词级表示时为一个词，clusters 的值在文档使用字符级和词级表示时一般是不同的。

例子（注：此处为了美观将json对象格式化为多行，在真实文件中每个文档需为1行）：

```
{
    "file_path": "file1.txt", 
    "genre": "bc",
    "context": ["[CLS]", "打", "雷", "了", "怎", "么", "发", "短", "信", "安", "慰", "女", "朋", "友", "？", "打", "雷", "时", "还", "给", "她", "发", "？", "[SEP]"],
    "clusters": [[[11, 14], [20, 21]], [[7, 9], [22, 22]]]],                   # (女朋友, 她)，(短信, "发"字后的零指代)
}
```

## 模型训练

1. 配置 config.py 中相关参数
2. 运行 ```python train.py```


## 模型测试

1. 配置 config.py 相关参数，将 evaluate.py 中的数据部分修改为希望测试的数据
2. 运行 ```pyhton evaluate.py```
