package translator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import edu.illinois.cs.cogcomp.core.datastructures.Pair;
import edu.illinois.cs.cogcomp.core.datastructures.trees.Tree;
import edu.illinois.cs.cogcomp.core.datastructures.trees.TreeTraversal;
import edu.illinois.cs.cogcomp.core.io.LineIO;
import edu.illinois.cs.cogcomp.edison.sentences.Constituent;
import edu.illinois.cs.cogcomp.edison.sentences.SpanLabelView;
import edu.illinois.cs.cogcomp.edison.sentences.TextAnnotation;
import edu.illinois.cs.cogcomp.edison.sentences.TreeView;
import edu.illinois.cs.cogcomp.edison.utilities.CollinsHeadFinder;
import edu.stanford.nlp.ling.CoreAnnotations.SentencesAnnotation;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.util.CoreMap;

public class GermanPrimeGenerator {

	private BufferedReader parse_reader;
	private List<Pair<String, String>> current_deprels;
	static int rule4hits = 0;
	static int rule5hits = 0;
	static int rule6hits = 0;

	public GermanPrimeGenerator(String deppath, String parsepath)
			throws FileNotFoundException, UnsupportedEncodingException {
		parse_reader = new BufferedReader(new InputStreamReader(
				new FileInputStream(parsepath), "UTF8"));
		;
	}

	public GermanPrimeGenerator() {

	}

	public static void main(String[] args) throws UnsupportedEncodingException, FileNotFoundException {
		BufferedReader de = new BufferedReader(new InputStreamReader(
				 new FileInputStream("data/dev_small.de-en.de"), "UTF8"));
		
	}
	// public void process(String srcFile) throws IOException {
	// String line;
	// TextAnnotation sent;
	// Tree<String> tree = null;
	// String treeStr = "";
	// int total = 0;
	//
	// while ((line = parse_reader.readLine()) != null) {
	// if (line.trim().equals("(())")) {
	// System.out.println();
	// continue;
	// }
	// if (line.trim().length() == 0) {
	// tree = Tree.readTreeFromString(treeStr);
	// sent = handleTree(tree);
	// total++;
	// treeStr = "";
	// } else {
	// treeStr += line.trim();
	// }
	// }
	// parse_reader.close();
	// // System.out.println("TOTAL TREES " + total);
	// // System.out.println(rule4hits);
	// // System.out.println(rule5hits);
	// // System.out.println(rule6hits);
	// }

	// private void verify(Tree<String> tree) {
	// List<String> tokens = getTokens(tree);
	// System.out.println("=========");
	// System.out.println(current_deprels.size());
	// System.out.println(tokens.size());
	// // System.out.println(current_deprels);
	// // System.out.println(tokens);
	// // parse_reader.close();
	// // System.out.println("TOTAL TREES " + total);
	// // System.out.println(rule4hits);
	// // System.out.println(rule5hits);
	// // System.out.println(rule6hits);
	// }

	TextAnnotation readTree(BufferedReader reader) throws IOException {
		String line;
		Tree<String> tree = null;
		String treeStr = "";
		int total = 0;
		TextAnnotation ta;
		while (true) {
			line = reader.readLine();
			if (line == null)
				return null;
			if (line.trim().equals("(())")) {
				return new TextAnnotation("", "", "");
			}
			if (line.trim().length() == 0) {
				tree = Tree.readTreeFromString(treeStr);
				ta = handleTree(tree);
				total++;
				return ta;
			} else {
				treeStr += line.trim();
			}
		}
	}

	// public static void main(String[] args) throws IOException {
	//
	// String text = LineIO.slurp("data/dev_small.de-en.en");
	// Reader sreader = new StringReader(text);
	// DocumentPreprocessor dp = new DocumentPreprocessor(sreader);
	// List<String> sentences = getStanfordSentences(dp);
	// System.out.println(sentences.size());
	// countParses();
	// System.exit(-1);
	// /*
	// GermanPrimeGenerator ts = new GermanPrimeGenerator();
	// BufferedReader de = new BufferedReader(new InputStreamReader(
	// new FileInputStream("data/dev_small.de-en.de"), "UTF8"));
	// BufferedReader reader = new BufferedReader(new InputStreamReader(
	// new FileInputStream("data/dev_small.de-en.de.parse.100.stp"),
	// "UTF8"));
	// int c = 0;
	// while (true) {
	// String line = de.readLine();
	// if (line == null) {
	// System.err.println("de finished");
	// break;
	// }
	// Reader sreader = new StringReader(line);
	// DocumentPreprocessor dp = new DocumentPreprocessor(sreader);
	// List<String> sentences = getStanfordSentences(dp);
	// System.out.println(sentences.size());
	// c += sentences.size();
	// }
	// System.out.println(c);
	// */
	// }
	//
	//
	// public static void main(String[] args) throws Exception {
	//
	// // String text = LineIO.slurp("data/dev_small.de-en.de");
	// // Reader sreader = new StringReader(text);
	// // DocumentPreprocessor dp = new DocumentPreprocessor(sreader);
	// // List<String> sentences = getStanfordSentences(dp);
	// // System.out.println(sentences.size());
	// // countParses();
	// // System.exit(-1);
	//
	// GermanPrimeGenerator ts = new GermanPrimeGenerator();
	// BufferedReader germanReader = new BufferedReader(new InputStreamReader(
	// new FileInputStream("data/dev_small.de-en.de"), "UTF8"));
	// BufferedReader parseReader = new BufferedReader(new InputStreamReader(
	// new FileInputStream("data/dev_small.de-en.de.parse.100.stp"),
	// "UTF8"));
	// BufferedWriter writer = new BufferedWriter(new
	// FileWriter("data/out.de"));
	//
	// // solveAllProblems(germanReader, parseReader, ts, writer);
	//
	// germanReader.close();
	// parseReader.close();
	// writer.close();
	//
	// // int c = 0;
	// // while (true) {
	// // String line = de.readLine();
	// // if (line == null) {
	// // System.err.println("de finished");
	// // break;
	// // }
	// // Reader sreader = new StringReader(line);
	// // DocumentPreprocessor dp = new DocumentPreprocessor(sreader);
	// // List<String> sentences = getStanfordSentences(dp);
	// // System.out.println(sentences.size());
	// // c += sentences.size();
	// // }
	// // System.out.println(c);
	//
	// }
	//
	/*
	 * public static void solveAllProblems(BufferedReader germanReader,
	 * BufferedReader parseReader, GermanPrimeGenerator ts, BufferedWriter
	 * writer) throws Exception { String outLine = ""; TextAnnotation ta, ta1,
	 * ta2;
	 * 
	 * ta1 = new TextAnnotation("", "", germanReader.readLine()); ta2 = new
	 * TextAnnotation("", "", germanReader.readLine());
	 * 
	 * while((ta = ts.readTree(parseReader)) != null) { double score1 =
	 * getUnigramBigramMatchScore(ta, ta1); double score2 =
	 * getUnigramBigramMatchScore(ta, ta2);
	 * System.out.println(score1+" "+score2);
	 * System.out.println(score1*1.0/score2); if(score1*1.0 / score2 > 1) {
	 * outLine += ta.getText() + " "; } else if(score1*1.0 / score2 < 0.4){
	 * System.out.println("Matched"); System.out.println("1: "+ta1.getText());
	 * System.out.println("Out : "+outLine); System.out.println(); ta1 = ta2;
	 * ta2 = new TextAnnotation("", "", germanReader.readLine());
	 * writer.write(outLine+"\n"); outLine = ta.getText() + " "; } else{
	 * if(score1 > score2) ts.readTree(parseReader); else { ta1 = ta2; ta2 = new
	 * TextAnnotation("", "", germanReader.readLine()); } } }
	 * 
	 * 
	 * }
	 * 
	 * // Normalized by first parameter size public static double
	 * getUnigramBigramMatchScore(TextAnnotation ta1, TextAnnotation ta2) {
	 * double sim = 0.0; if(ta1 == null || ta2 == null) return 0.0; for(int i=0;
	 * i<ta1.size(); ++i) { for(int j=0; j<ta2.size(); ++j) {
	 * if(ta1.getToken(i).toLowerCase().equals(ta2.getToken(j).toLowerCase())) {
	 * sim += 1.0; break; } } } return sim / ta1.size(); }
	 */
	static void countParses() throws IOException {
		BufferedReader reader = new BufferedReader(new InputStreamReader(
				new FileInputStream("data/dev_small.de-en.de.parse.100.stp"),
				"UTF8"));
		GermanPrimeGenerator ts = new GermanPrimeGenerator();
		TextAnnotation ta = ts.readTree(reader);
		int c = 1;
		while (ta != null) {
			// System.out.println(ta.getText());
			c++;
			ta = ts.readTree(reader);
		}
		System.out.println(c);
	}

//	public static void main(String[] args) throws IOException {
//		GermanPrimeGenerator ts = new GermanPrimeGenerator();
//		BufferedReader ge = new BufferedReader(new InputStreamReader(
//				new FileInputStream(args[0]), "UTF8"));
//		BufferedReader reader = new BufferedReader(new InputStreamReader(
//				new FileInputStream(args[1]), "UTF8"));
//
//		while (true) {
//			String line = ge.readLine();
//			if (line == null) {
//				System.err.println("german finished");
//				return;
//			}
//			// Reader sreader = new StringReader(line);
//			// DocumentPreprocessor dp = new DocumentPreprocessor(sreader);
//			// List<String> sentences = getStanfordSentences(dp);
//			// System.out.println(sentences.size());
//			TextAnnotation ta = new TextAnnotation("de", "german", line);
//			// for (int i = 0; i < sentences.size(); i++) {
//			String buf = "";
//			for (int i = 0; i < ta.getNumberOfSentences(); i++) {
//				TextAnnotation gta = ts.readTree(reader);
//				if (gta == null) {
//					System.err.println("parses finished");
//					return;
//				}
//				buf += gta.getText() + " ";
//				// System.out.print(gta.getText() + " ");
//			}
//			// System.out.println(buf.length()+"vs"+line.length());
//			// System.out.println(buf.length()*1.0/line.length());
//			// System.out.println((buf.length() -line.length()));
//			// if(buf.length()*1.0/line.length() > 1.3)
//			// if(buf.length() - line.length() > 60)
//			// {
//			// System.out.println("skipping");
//			// ge.readLine();
//			// }
//			// else if(line.length() - buf.length() > 60)
//			// {
//			// System.out.println("skipping");
//			// ts.readTree(reader);
//			// }
//			// else{
//			// System.out.println("LINE: "+line);
//			// System.out.print("MATCHED: ");
//			System.out.println(buf);
//			// }
//			// System.out.println();
//		}
//	}

	// public static void main(String[] args) throws IOException {
	//
	// // Properties props = new Properties();
	// // props.setProperty("annotators",
	// // "tokenize, ssplit, pos, lemma");
	// // StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
	//
	// GermanPrimeGenerator ts = new GermanPrimeGenerator();
	// // ts.process("data/dev_small.de-en.de");
	// BufferedReader reader = new BufferedReader(new InputStreamReader(
	// new FileInputStream("data/dev_small.de-en.de.parse.100.stp"),
	// "UTF8"));
	// BufferedReader src = new BufferedReader(new InputStreamReader(
	// new FileInputStream("data/dev_small.de-en.de"), "UTF8"));
	// String curr_line = src.readLine();
	// String buf = "";
	// TextAnnotation ta = ts.readTree(reader);
	// while (ta!=null) {
	//
	// if (ta.getText().length() != 0)
	// {
	// buf += ta.getText()+" ";
	// // System.out.println(ta.getText());
	// }
	// if (buf.length() != 0 && testMatch(curr_line,buf)) {
	// System.out.println(buf);
	// curr_line = src.readLine();
	// buf = "";
	// }
	// ta = ts.readTree(reader);
	// }
	// // int c=1;
	// // while(ta!=null)
	// // {
	// // System.out.println(ta.getText());
	// // c++;
	// // ta = ts.readTree(reader);
	// // }
	// // System.out.println(c);
	//
	// // ArrayList<String> lines = LineIO.read("data/dev_small.de-en.de");
	// // c=0;
	// // for(int i=0;i<lines.size();i++)
	// // {
	// // String curr_line = lines.get(i);
	// // Annotation document = new Annotation(curr_line);
	// // pipeline.annotate(document);
	// // List<CoreMap> sentences = document.get(SentencesAnnotation.class);
	// // c+=sentences.size();
	// // // ta = new TextAnnotation("de", "german", curr_line);
	// // // c+=ta.getNumberOfSentences();
	// // }
	// // System.out.println(c);
	// //
	// /*
	// * ArrayList<String> lines = LineIO.read("data/dev_small.de-en.de");
	// * TextAnnotation ta = ts.readTree(reader); String[] toks =
	// * ta.getTokens(); int i=0; String buf=ta.getText(); String
	// * curr_line=lines.get(0); while(true) {
	// * if(curr_line.endsWith(toks[toks.length-1])) {
	// * System.out.println("LINE:"+buf); i++; curr_line = lines.get(i);
	// * buf=""; } else{ ta=ts.readTree(reader); toks = ta.getTokens();
	// * buf+=ta.getText(); }
	// *
	// * if(i==lines.size()-1) break; }
	// */
	// }

	private static List<String> getStanfordSentences(DocumentPreprocessor dp) {
		List<String> sentenceList = new ArrayList<String>();
		for (List<HasWord> sentence : dp) {
			String sentenceString = Sentence.listToString(sentence);
			sentenceList.add(sentenceString.toString());
		}

		// for (String sentence : sentenceList) {
		// System.out.println(sentence);
		// }
		return sentenceList;
	}

	private static boolean testMatch(String curr_line, String buf) {
		if (buf.length() == 0)
			return false;
		String[] tokens = buf.split("\\s+");
		int end = tokens.length - 1;
		if (curr_line.endsWith(tokens[end - 1] + tokens[end]))
			return true;
		return false;
	}

	public void processSplits(String split_eng, String split_ger,
			String finalGermanfile, String finalEngfile) throws IOException {

		BufferedReader german_prime = new BufferedReader(new FileReader(
				split_ger));
		BufferedReader eng_sent = new BufferedReader(new FileReader(split_eng));
		PairReader p = new PairReader(german_prime, eng_sent);
		PrintWriter english_aligned = new PrintWriter(new BufferedWriter(
				new FileWriter(finalEngfile, true)));
		PrintWriter germanprime_aligned = new PrintWriter(new BufferedWriter(
				new FileWriter(finalGermanfile, true)));

		String gline, eline;
		Tree<String> tree = null;
		String treeStr = "";
		int total = 0;
		Pair<String, String> tmp;
		while ((tmp = p.next()) != null) {
			gline = tmp.getFirst();
			eline = tmp.getSecond();
			if (gline.trim().equals("(())")) {
				continue;
			}
		}
		german_prime.close();
		english_aligned.println("the text");
		germanprime_aligned.println("the text");

		english_aligned.close();
		germanprime_aligned.close();
	}

	public static TextAnnotation handleTree(Tree<String> tree) throws IOException {
		if (tree == null)
			return null;
		applyRule4(tree);
		applyRule6(tree);
		List<String> tokens = getTokens(tree);

		TextAnnotation ta = new TextAnnotation("", "", tokens);
		TreeView view = new TreeView("", "", ta, 1.0);
		view.setParseTree(0, tree);

		// if (!tokens.get(tokens.size() - 1).equals("."))
		// System.out.print(ta.getText() + " ");
		// else
		// System.out.println(ta.getText());
		return ta;
	}

	private static List<String> getTokens(Tree<String> tree) {
		List<String> tokens = new ArrayList<String>();
		String s = "";
		for (Tree<String> leaf : tree.getYield()) {
			String tok = leaf.toString();
			tokens.add(tok.substring(1, tok.length() - 1));
			s += tok.substring(1, tok.length() - 1) + " ";
		}
		// System.out.println(s);
		// s=s.replaceAll(" \\$ ", "");
		// s=s.replace(" ¶ ", "");
		// s=s.replace(" 1/4 ", "");
		// s=s.replace("Ã ", "Ã");
		// return Arrays.asList(s.split("\\s+"));
		// return act_tok;
		return tokens;
	}

	static int rule4 = 0;
	static int rule5 = 0;
	static int rule6 = 0;

	static Tree<String> applyRule4(Tree<String> tree) {
		for (Tree<String> node : TreeTraversal.breadthFirstTraversal(tree)) {
			if (node.getLabel().equals("S")) // clauses
			{
				List<String> childLabels = new ArrayList<String>();
				for (Tree<String> child : node.getChildren()) {
					childLabels.add(child.getLabel());
				}
				if (childLabels.contains("VVFIN")
						&& childLabels.contains("PTKVZ")) {

					int insert_loc = childLabels.indexOf("VVFIN");
					int remove_loc = childLabels.indexOf("PTKVZ");
					Tree<String> particle = node.getChild(remove_loc);
					node.removeChildAt(remove_loc);
					node.addSubtreeAt(particle, insert_loc);

					rule4hits++;
				}
			}
		}
		return tree;
	}

	/**
	 * incomplete, needs dep view to be aligned
	 * 
	 * @param tree
	 * @return
	 */
	Tree<String> applyRule5(Tree<String> tree) {
		removeInternal("VP", tree);
		for (Tree<String> node : TreeTraversal.breadthFirstTraversal(tree)) {
			if (node.getLabel().equals("VP")) {
				// replace node with its children
			}
			if (node.getLabel().equals("S")) // clauses
			{
				if (Dominates(node, "VVFIN") && Dominates(node, "VVINF")) {
					Tree<String> vvfin_node = findChildDominating(node, "VVFIN");
					Tree<String> vvinf_node = findChildDominating(node, "VVINF");
					int vvfin_pos = vvfin_node
							.getPositionAmongParentsChildren();
					int vvinf_pos = vvinf_node
							.getPositionAmongParentsChildren();
					int left = (vvfin_pos < vvinf_pos) ? vvfin_pos : vvinf_pos;
					int right = (vvfin_pos > vvinf_pos) ? vvfin_pos : vvinf_pos;

					System.out.println(current_deprels.size());
					System.out.println(getTokens(tree).size());
					System.out.println(current_deprels);
					System.out.println(getTokens(tree));
				}
			}
		}

		return tree;
	}

	private static Tree<String> applyRule6(Tree<String> tree) {
		removeInternal("VP", tree);
		for (Tree<String> node : TreeTraversal.breadthFirstTraversal(tree)) {

			if (node.getLabel().equals("S")) // clauses
			{
				if (Dominates(node, "VVFIN") && Dominates(node, "VVINF")
						&& Dominates(node, "PTKNEG")) {
					Tree<String> vvfin_node = findChildDominating(node, "VVFIN");
					Tree<String> ptkneg_node = findChildDominating(node,
							"PTKNEG");
					node.removeChildAt(node.getChildren().indexOf(ptkneg_node));
					node.addSubtreeAt(ptkneg_node,
							node.getChildren().indexOf(vvfin_node) + 1);
					rule6hits++;

				}
			}
		}

		return tree;
	}

	private static void removeInternal(String string, Tree<String> tree) {
		for (Tree<String> node : TreeTraversal.breadthFirstTraversal(tree)) {
			if (node.getLabel().equals("VP")) {
				Tree<String> parent = node.getParent();
				if (parent != null) {
					int mypos = node.getPositionAmongParentsChildren();

					parent.removeChildAt(mypos);
					for (Tree<String> child : node.getChildren())
						parent.addSubtreeAt(child, mypos);
				}
			}
		}
	}

	private static Tree<String> findChildDominating(Tree<String> node,
			String string) {
		for (Tree<String> child : node.getChildren()) {
			if (Dominates(child, string))
				return child;
		}
		return null;
	}

	private static boolean Dominates(Tree<String> node, String string) {
		if (hasLeafAsChildren(node)) {
			// System.out.println("LABEL:"+node.getLabel());
			return node.getLabel().equals(string);
		}
		for (Tree<String> child : node.getChildren()) {
			if (Dominates(child, string))
				return true;
		}
		return false;
	}

	private static boolean hasLeafAsChildren(Tree<String> node) {
		for (Tree<String> c : node.getChildren()) {
			if (c.isLeaf())
				return true;
		}
		return false;
	}
}
