/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.ccg.CCGNode;
import edu.pku.coli.ccg.CCGTerminalNode;
import edu.pku.coli.syntax.ConstTree;
import edu.pku.coli.syntax.avm.AttributeValueMatrix;
import edu.pku.coli.viewer.DepTree;
import edu.pku.coli.viewer.Edge;
import edu.pku.coli.viewer.Token;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParseResultIO {
    private ArrayList<LinkedHashMap<Integer, Token>> tokenLists = new ArrayList();
    private ArrayList<ConstTree> constTreebank = new ArrayList();
    private ArrayList<DepTree> depTreebank = new ArrayList();
    private ArrayList<DepTree> deepdepTreebank = new ArrayList();
    private ArrayList<CCGNode> CCGTreebank = new ArrayList();
    private ArrayList<Element> LFGStructbank = new ArrayList();
    private String filename;
    private String cstruct = null;
    private AttributeValueMatrix fstruct = null;
    private boolean[] masks = new boolean[6];

    public XMLParseResultIO(String filename) {
        this.setFilename(filename);
    }

    public ArrayList<LinkedHashMap<Integer, Token>> getTokenLists() {
        return this.tokenLists;
    }

    public ArrayList<ConstTree> getConstTreebank() {
        return this.constTreebank;
    }

    public ArrayList<DepTree> getDepTreebank() {
        return this.depTreebank;
    }

    public ArrayList<DepTree> getDeepdepTreebank() {
        return this.deepdepTreebank;
    }

    public ArrayList<CCGNode> getCCGTreebank() {
        return this.CCGTreebank;
    }

    public ArrayList<Element> getLFGStructbank() {
        return this.LFGStructbank;
    }

    public void setTokenLists(List<LinkedHashMap<Integer, Token>> tokenLists) {
        this.tokenLists.clear();
        this.tokenLists.addAll(tokenLists);
    }

    public void setConstTreebank(List<ConstTree> constTreebank) {
        this.constTreebank.clear();
        this.constTreebank.addAll(constTreebank);
    }

    public void setDepTreebank(List<DepTree> depTreebank) {
        this.depTreebank.clear();
        this.depTreebank.addAll(depTreebank);
    }

    public void setDeepdepTreebank(List<DepTree> deepdepTreebank) {
        this.deepdepTreebank.clear();
        this.deepdepTreebank.addAll(deepdepTreebank);
    }

    public void setCCGTreebank(List<CCGNode> cCGTreebank) {
        this.CCGTreebank.clear();
        this.CCGTreebank.addAll(this.CCGTreebank);
    }

    public void setLFGStructbank(List<Element> LFGStructbank) {
        this.LFGStructbank.clear();
        this.LFGStructbank.addAll(LFGStructbank);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setMask(int index, boolean mask) {
        if (index > 5 || index < 0) {
            return;
        }
        this.masks[index] = mask;
    }

    public void setMasks(boolean[] masks) {
        if (this.masks.length == masks.length) {
            this.masks = masks;
        }
    }

    public void importFromFile() throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            System.out.println(this.filename);
            Document doc = builder.parse(new InputSource(new FileReader(this.filename)));
            this.importView(doc);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    private void importView(Document doc) {
        Element docRoot = doc.getDocumentElement();
        NodeList children = docRoot.getChildNodes();
        ArrayList<Element> Sentences = new ArrayList<Element>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Sentences.add((Element)child);
            }
            ++i;
        }
        int sentNum = 0;
        sentNum = 0;
        while (sentNum < Sentences.size()) {
            Element sent = (Element)Sentences.get(sentNum);
            boolean constTreeAdded = false;
            boolean depTreeAdded = false;
            boolean deepdepTreeAdded = false;
            boolean CCGTreeAdded = false;
            boolean LFGStructAdded = false;
            if (sent instanceof Element) {
                NodeList sentChildren = sent.getChildNodes();
                LinkedHashMap<Integer, Token> tokenList = new LinkedHashMap<Integer, Token>();
                int j = 0;
                while (j < sentChildren.getLength()) {
                    String depStr;
                    Node sentElement = sentChildren.item(j);
                    if (!(!(sentElement instanceof Element) || sentElement.getNodeName() != "wordlist" || this.masks[0] && this.masks[2] && this.masks[3])) {
                        Element tokenls = (Element)sentElement;
                        NodeList tokls = tokenls.getChildNodes();
                        int k = 0;
                        while (k < tokls.getLength()) {
                            Node tok = tokls.item(k);
                            if (tok instanceof Element) {
                                String AttrValue;
                                String AttrName;
                                Node Attribute;
                                Token token = null;
                                NamedNodeMap Attributes = tok.getAttributes();
                                int m = 0;
                                while (m < Attributes.getLength()) {
                                    Attribute = Attributes.item(m);
                                    if (Attribute instanceof Attr) {
                                        AttrName = ((Attr)Attribute).getName();
                                        AttrValue = ((Attr)Attribute).getValue();
                                        if (AttrName.equals("id")) {
                                            token = new Token(Integer.parseInt(AttrValue));
                                            break;
                                        }
                                    }
                                    ++m;
                                }
                                m = 0;
                                while (m < Attributes.getLength()) {
                                    Attribute = Attributes.item(m);
                                    if (Attribute instanceof Attr) {
                                        AttrName = ((Attr)Attribute).getName();
                                        AttrValue = ((Attr)Attribute).getValue();
                                        if (token != null) {
                                            token.addProperty(AttrName, AttrValue);
                                        }
                                    }
                                    ++m;
                                }
                                tokenList.put(token.getID(), token);
                            }
                            ++k;
                        }
                        if (!tokenList.isEmpty()) {
                            this.tokenLists.add(tokenList);
                        } else {
                            this.tokenLists.add(null);
                        }
                    } else if (sentElement instanceof Element && sentElement.getNodeName() == "constree" && !this.masks[1]) {
                        children = sentElement.getChildNodes();
                        String constStr = new String();
                        int k = 0;
                        while (k < children.getLength()) {
                            Node constTextNode = children.item(k);
                            if (constTextNode instanceof Text) {
                                constStr = ((Text)constTextNode).getTextContent();
                            }
                            ++k;
                        }
                        if (!constStr.trim().isEmpty()) {
                            ConstTree constTree = ConstTree.ConstTreeIO.ReadConstTree((String)constStr);
                            this.constTreebank.add(constTree);
                        } else {
                            this.constTreebank.add(null);
                        }
                        constTreeAdded = true;
                    } else if (sentElement instanceof Element && sentElement.getNodeName() == "deptree" && !this.masks[2]) {
                        children = sentElement.getChildNodes();
                        depStr = new String();
                        int k = 0;
                        while (k < children.getLength()) {
                            Node depTextNode = children.item(k);
                            if (depTextNode instanceof Text) {
                                depStr = ((Text)depTextNode).getTextContent();
                            }
                            ++k;
                        }
                        if (!depStr.trim().isEmpty()) {
                            DepTree depTree = new DepTree();
                            depTree.loadTokens(tokenList);
                            depTree.loadEdges(depStr.trim());
                            this.depTreebank.add(depTree);
                        } else {
                            this.depTreebank.add(null);
                        }
                        depTreeAdded = true;
                    } else if (sentElement instanceof Element && sentElement.getNodeName() == "deepdep" && !this.masks[3]) {
                        children = sentElement.getChildNodes();
                        depStr = new String();
                        int k = 0;
                        while (k < children.getLength()) {
                            Node depTextNode = children.item(k);
                            if (depTextNode instanceof Text) {
                                depStr = ((Text)depTextNode).getTextContent();
                            }
                            ++k;
                        }
                        if (!depStr.trim().isEmpty()) {
                            DepTree depTree = new DepTree();
                            depTree.loadTokens(tokenList);
                            depTree.loadEdges(depStr.trim());
                            this.deepdepTreebank.add(depTree);
                        } else {
                            this.deepdepTreebank.add(null);
                        }
                        deepdepTreeAdded = true;
                    } else if (sentElement instanceof Element && sentElement.getNodeName() == "lfg" && !this.masks[4]) {
                        this.LFGStructbank.add((Element)sentElement);
                        LFGStructAdded = true;
                    } else if (sentElement instanceof Element && sentElement.getNodeName() == "ccg" && !this.masks[5]) {
                        children = sentElement.getChildNodes();
                        String CCGStr = new String();
                        int k = 0;
                        while (k < children.getLength()) {
                            Node CCGTextNode = children.item(k);
                            if (CCGTextNode instanceof Text) {
                                CCGStr = ((Text)CCGTextNode).getTextContent();
                            }
                            ++k;
                        }
                        if (CCGStr.trim().matches("^\\( *\\)$")) {
                            CCGTerminalNode CCGTree = new CCGTerminalNode("<L _ _ _ _ _>", 0);
                            this.CCGTreebank.add((CCGNode)CCGTree);
                        } else if (!CCGStr.trim().isEmpty()) {
                            CCGStr = CCGStr.replace('{', '<');
                            CCGStr = CCGStr.replace('}', '>');
                            CCGNode CCGTree = CCGNode.getCCGNodeFromString((String)CCGStr.trim());
                            this.CCGTreebank.add(CCGTree);
                        } else {
                            this.CCGTreebank.add(null);
                        }
                        CCGTreeAdded = true;
                    }
                    ++j;
                }
            }
            if (!constTreeAdded) {
                this.constTreebank.add(null);
            }
            if (!depTreeAdded) {
                this.depTreebank.add(null);
            }
            if (!deepdepTreeAdded) {
                this.deepdepTreebank.add(null);
            }
            if (!CCGTreeAdded) {
                this.CCGTreebank.add(null);
            }
            if (!LFGStructAdded) {
                this.LFGStructbank.add(null);
            }
            ++sentNum;
        }
    }

    public void outputToFile() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.filename));
        bw.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        bw.write("<viewer>\n");
        int i = 0;
        while (true) {
            int j;
            String edgeStr;
            ConstTree constree = null;
            DepTree deptree = null;
            DepTree deepdep = null;
            CCGNode ccgtree = null;
            Element lfgstruct = null;
            LinkedHashMap<Integer, Token> toklist = null;
            if (i < this.constTreebank.size()) {
                constree = this.constTreebank.get(i);
            }
            if (i < this.depTreebank.size()) {
                deptree = this.depTreebank.get(i);
            }
            if (i < this.deepdepTreebank.size()) {
                deepdep = this.deepdepTreebank.get(i);
            }
            if (i < this.CCGTreebank.size()) {
                ccgtree = this.CCGTreebank.get(i);
            }
            if (i < this.LFGStructbank.size()) {
                lfgstruct = this.LFGStructbank.get(i);
            }
            if (i < this.tokenLists.size()) {
                toklist = this.tokenLists.get(i);
            }
            if (constree == null && deptree == null && deepdep == null && ccgtree == null && lfgstruct == null && toklist == null) break;
            bw.write("<sentence id=\"" + String.valueOf(i) + "\">");
            bw.newLine();
            if (toklist != null) {
                bw.write("<wordlist length=\"" + toklist.size() + "\">");
                bw.newLine();
                for (Integer index : toklist.keySet()) {
                    bw.write("<tok id=\"" + index + "\" head=\"" + toklist.get(index).gethead() + "\"/>");
                    bw.newLine();
                }
                bw.write("</wordlist>");
                bw.newLine();
            }
            if (constree != null) {
                bw.write("<constree>");
                bw.write("( " + constree.toString() + ")");
                bw.write("</constree>");
                bw.newLine();
            }
            if (deptree != null) {
                bw.write("<deptree>");
                bw.newLine();
                for (Edge edge : deptree.getEdgelist()) {
                    edgeStr = "(" + edge.getStart() + ", " + edge.getEnd() + ", " + edge.getLabel();
                    j = 0;
                    while (j < edge.getPropLength()) {
                        edgeStr = String.valueOf(edgeStr) + ", " + edge.getProp(j);
                        ++j;
                    }
                    edgeStr = String.valueOf(edgeStr) + ")";
                    bw.write(edgeStr);
                    bw.newLine();
                }
                bw.write("</deptree>");
                bw.newLine();
            }
            if (deepdep != null) {
                bw.write("<deepdep>");
                bw.newLine();
                for (Edge edge : deepdep.getEdgelist()) {
                    edgeStr = "(" + edge.getStart() + ", " + edge.getEnd() + ", " + edge.getLabel();
                    j = 0;
                    while (j < edge.getPropLength()) {
                        edgeStr = String.valueOf(edgeStr) + ", " + edge.getProp(j);
                        ++j;
                    }
                    edgeStr = String.valueOf(edgeStr) + ")";
                    bw.write(edgeStr);
                    bw.newLine();
                }
                bw.write("</deepdep>");
                bw.newLine();
            }
            if (lfgstruct != null) {
                this.loadLFG(lfgstruct);
                bw.write("<lfg>");
                bw.newLine();
                bw.write("<cstruct>");
                bw.write(this.cstruct);
                bw.write("</cstruct>");
                bw.newLine();
                List xmlist = AttributeValueMatrix.ExportToXMLSentence((AttributeValueMatrix)this.fstruct);
                for (String s : xmlist) {
                    bw.write(s);
                    bw.newLine();
                }
                bw.write("</lfg>");
                bw.newLine();
            }
            bw.write("</sentence>");
            bw.newLine();
            ++i;
        }
        bw.write("</viewer>");
        bw.close();
    }

    private void loadLFG(Element headNode) {
        Node child;
        NodeList children = headNode.getChildNodes();
        Node cstructNode = null;
        Element fstructNode = null;
        int i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if (child instanceof Element && child.getNodeName() == "cstruct") {
                cstructNode = (Element)child;
            } else if (child instanceof Element && child.getNodeName() == "fstruct") {
                fstructNode = (Element)child;
            }
            ++i;
        }
        if (cstructNode != null) {
            children = cstructNode.getChildNodes();
        }
        i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if (child instanceof Text) {
                this.cstruct = ((Text)child).getTextContent();
            }
            ++i;
        }
        if (fstructNode != null) {
            AttributeValueMatrix.flushLargestID();
            this.fstruct = AttributeValueMatrix.parseXMLSentence(fstructNode);
        }
    }
}

