/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.langidtime;

import babel.content.pages.Page;
import babel.prep.PrepStep;
import babel.prep.langidtime.LangAndTimeMapper;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class LangAndTimeExtractor
extends PrepStep {
    static final Log LOG = LogFactory.getLog(LangAndTimeExtractor.class);
    protected static final String PAGES_SUBDIR = "pages";
    protected static final String JOB_PROP_JOB_REFERRER = "langidentifier.referrer";

    protected JobConf createJobConf(String crawlDir, String pagesSubDir, String referrer) throws IOException {
        JobConf job = new JobConf(this.getConf());
        job.setJobName("identify languages and collect time for pages in " + pagesSubDir);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(LangAndTimeMapper.class);
        job.setOutputFormat(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Page.class);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(crawlDir, pagesSubDir));
        Path outDir = new Path(new Path(crawlDir, PAGES_SUBDIR), "pages.langidtime." + this.getCurTimeStamp());
        this.m_fs.delete(outDir, true);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        this.setUniqueTempDir(job);
        job.set(JOB_PROP_JOB_REFERRER, referrer);
        return job;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            LangAndTimeExtractor.usage();
            return;
        }
        LangAndTimeExtractor identifier = new LangAndTimeExtractor();
        JobConf job = identifier.createJobConf(args[0], args[1], args[2]);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("LangAndTimeExtractor: " + job.getJobName()));
        }
        identifier.runPrepStep(job);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(String.valueOf(Stats.dumpStats()) + "\n"));
            LOG.info((Object)("Output: " + FileOutputFormat.getOutputPath((JobConf)job)));
            LOG.info((Object)"LangAndTimeExtractor: done");
        }
    }

    protected static void usage() {
        System.err.println("Usage: LangAndTimeExtractor crawl_dir pages_subdir referrer_url\n");
    }

    static class Stats {
        private static HashMap<String, Integer> pageLangCounts = new HashMap();
        private static HashMap<String, Integer> pageNewLangCounts = new HashMap();
        private static int pageFailedLangCount = 0;
        private static HashMap<String, Integer> verLangCounts = new HashMap();
        private static HashMap<String, Integer> verNewLangCounts = new HashMap();
        private static int verFailedLangCount = 0;
        private static HashMap<String, Integer> verTimeCounts = new HashMap();
        private static HashMap<String, Integer> verNewTimeCounts = new HashMap();
        private static int verFailedTimeCount = 0;

        Stats() {
        }

        public static synchronized void incLangPageCount(String lang, Page page) {
            int curCount = pageLangCounts.containsKey(lang) ? pageLangCounts.get(lang) + 1 : 1;
            pageLangCounts.put(lang, curCount);
            curCount = verLangCounts.containsKey(lang) ? verLangCounts.get(lang) + page.pageVersions().size() : page.pageVersions().size();
            verLangCounts.put(lang, curCount);
        }

        public static synchronized void incNewLangPageCount(String lang, Page page) {
            int curCount = pageNewLangCounts.containsKey(lang) ? pageNewLangCounts.get(lang) + 1 : 1;
            pageNewLangCounts.put(lang, curCount);
            curCount = verNewLangCounts.containsKey(lang) ? verNewLangCounts.get(lang) + page.pageVersions().size() : page.pageVersions().size();
            verNewLangCounts.put(lang, curCount);
        }

        public static synchronized void incFailedLangPageCount(Page page) {
            ++pageFailedLangCount;
            verFailedLangCount += page.pageVersions().size();
        }

        public static synchronized void incTimeVerCount(String lang) {
            int curCount = verTimeCounts.containsKey(lang) ? verTimeCounts.get(lang) + 1 : 1;
            verTimeCounts.put(lang, curCount);
        }

        public static synchronized void incNewTimeVerCount(String lang) {
            int curCount = verNewTimeCounts.containsKey(lang) ? verNewTimeCounts.get(lang) + 1 : 1;
            verNewTimeCounts.put(lang, curCount);
        }

        public static synchronized void incFailedTimeVerCount() {
            ++verFailedTimeCount;
        }

        public static String dumpStats() {
            StringBuilder strBld = new StringBuilder();
            strBld.append("Existing counts:\n");
            for (String lang : pageLangCounts.keySet()) {
                strBld.append(String.valueOf(lang) + " : " + pageLangCounts.get(lang) + " pages containing " + verLangCounts.get(lang) + " versions of which " + (verTimeCounts.containsKey(lang) ? (Comparable)verTimeCounts.get(lang) : "0") + " are time stamped.\n");
            }
            strBld.append("\nOf those these were just extracted:\n");
            for (String lang : pageNewLangCounts.keySet()) {
                strBld.append(String.valueOf(lang) + " : " + pageNewLangCounts.get(lang) + " pages containing " + verNewLangCounts.get(lang) + " versions of which " + (verNewTimeCounts.containsKey(lang) ? (Comparable)verNewTimeCounts.get(lang) : "0") + " are time stamped.\n");
            }
            strBld.append("\nOther stats:\n");
            strBld.append(String.valueOf(pageFailedLangCount) + " pages (" + verFailedLangCount + " versions) with no languages detected.\n");
            strBld.append(String.valueOf(verFailedTimeCount) + " page versions with detected language but no timestamp.\n");
            return strBld.toString();
        }
    }
}

