#!/usr/bin/env perl

use strict;
use utf8;
binmode STDIN, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

if ( @ARGV != 1 ) {
    print "$0 <new_conjunction_rule>\n";
    exit;
}
my %rule_;
&read_rule( $ARGV[0] );
&main();


sub main {

    while ( <STDIN> ) {
	chomp;
	my $line = $_;
	my ( $surface_form_ref, $surface_pos_ref, $normal_form, $normal_reading, $normal_pos, $citation_form ) = &read_entry( $line );
	
	my %hash;
	my @surface_forms = @{$surface_form_ref};
	my @surface_pos = @{$surface_pos_ref};
	for ( my$i = 0; $i < @surface_forms; ++$i ) {
	    $hash{"$surface_forms[$i]\t$surface_pos[$i]"} = 1;
	    if ( defined $rule_{$surface_pos[$i]} ) {
		for ( my$j = 0; $j < @{$rule_{$surface_pos[$i]}}; ++$j ) {
		    my $old_suffix   = $rule_{$surface_pos[$i]}[$j]{"old_suffix"};
		    my @new_suffixes = @{$rule_{$surface_pos[$i]}[$j]{"new_suffix"}};
		    if ( $surface_forms[$i] =~ /(.*)$old_suffix$/ ) {
			my $stem = $1;
			for my$new_suffix ( @new_suffixes ) {
			    $hash{"$stem$new_suffix\t$surface_pos[$i]"} = 1;
			}
		    }
		}
	    }
	}
	for ( keys %hash ) {
	    print "$_\t";
	}
	print "$normal_form\t$normal_reading\t$normal_pos\t$citation_form\n";
    }
}


sub read_rule{

    my ( $filename ) = @_;
    
    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	next if ( /^\$/ || /^$/ );
	my @tmp = split( /\s/, $_ );
	my @surface_pos  = split( /\//, $tmp[0] );
	my $old_suffix   = $tmp[1];
	my @new_suffixes = split( /\//, $tmp[2] );
	for my$surface_pos ( @surface_pos ) {
	    push( @{$rule_{$surface_pos}}, { "old_suffix" => $old_suffix, "new_suffix" => [ @new_suffixes ] } );
	}
    }
    close( TEXT );
}


sub read_entry {

    my ( $line ) = @_;
    my ( @surface_forms, @surface_pos, $normal_form, $normal_reading, $normal_pos, $citation_form );
    my @data = split( /\t/, $line );

    $citation_form  = pop @data;
    $normal_pos     = pop @data;
    $normal_reading = pop @data;
    $normal_form    = pop @data;
    for ( my$i = 0; $i < @data; $i += 2 ) {
	push( @surface_forms, $data[$i] );
	push( @surface_pos, $data[$i+1] );
    }
    return ( [ @surface_forms ], [ @surface_pos ], $normal_form, $normal_reading, $normal_pos, $citation_form );
}
