/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.features.ModifiedFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownFeatureExtractor<E>
extends ModifiedFeatureExtractor<E>
implements Serializable {
    static final long serialVersionUID = 973305985402711781L;
    private final Set<String> mKnownFeatureSet;

    public KnownFeatureExtractor(FeatureExtractor<? super E> baseExtractor, Set<String> knownFeatureSet) {
        super(baseExtractor);
        this.mKnownFeatureSet = knownFeatureSet;
    }

    @Override
    public Number filter(String feature, Number value) {
        return this.mKnownFeatureSet.contains(feature) ? value : null;
    }

    public Set<String> knownFeatureSet() {
        return Collections.unmodifiableSet(this.mKnownFeatureSet);
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -8477676811264111403L;
        final KnownFeatureExtractor<F> mExtractor;

        public Serializer(KnownFeatureExtractor<F> extractor) {
            this.mExtractor = extractor;
        }

        public Serializer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(((KnownFeatureExtractor)this.mExtractor).mKnownFeatureSet.size());
            for (String s : ((KnownFeatureExtractor)this.mExtractor).mKnownFeatureSet) {
                out.writeUTF(s);
            }
            out.writeObject(this.mExtractor.baseExtractor());
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            HashSet<String> knownFeatureSet = new HashSet<String>(3 * size / 2);
            for (int i = 0; i < size; ++i) {
                knownFeatureSet.add(in.readUTF());
            }
            FeatureExtractor baseExtractor = (FeatureExtractor)in.readObject();
            return new KnownFeatureExtractor(baseExtractor, knownFeatureSet);
        }
    }
}

