/*
 * Decompiled with CFR 0.152.
 */
package commandln;

import commandln.IParam;
import java.io.BufferedReader;
import java.io.FileReader;

public class CommandLineParser {
    private IParam mParams = null;

    public CommandLineParser(IParam iParam) {
        this.mParams = iParam;
    }

    public void Parse(String[] stringArray) throws Exception {
        if (stringArray.length == 2 && stringArray[0].equals("-config")) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[1]));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + " ");
            }
            stringArray = stringBuilder.toString().split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        }
        boolean bl = false;
        for (String string : stringArray) {
            string = string.replace("\"", "");
            if (bl) {
                this.mParams.ParseValue(string);
                this.mParams.MarkAsFound();
                bl = false;
                continue;
            }
            if (!this.mParams.CompareName(string)) continue;
            if (this.mParams.ValueRequired()) {
                bl = true;
                continue;
            }
            this.mParams.MarkAsFound();
        }
        if (!this.mParams.IsFound()) {
            throw new Exception("Not all mandatory params specified");
        }
    }

    public String getStringValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getString();
        }
        throw new Exception("Param not found");
    }

    public boolean getBoolValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getBool();
        }
        throw new Exception("Param not found");
    }

    public int getIntValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getInt();
        }
        throw new Exception("Param not found");
    }

    public double getDoubleValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getDouble();
        }
        throw new Exception("Param not found");
    }

    public String[] getStringArrayValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getStringArray();
        }
        throw new Exception("Param not found");
    }

    public int[] getIntArrayValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getIntArray();
        }
        throw new Exception("Param not found");
    }

    public double[] getDoubleArrayValue(String string) throws Exception {
        if (this.mParams.CompareName(string)) {
            return this.mParams.getDoubleArray();
        }
        throw new Exception("Param not found");
    }
}

