/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.ChunkHandlerAdapter2;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.CompiledEstimator;
import com.aliasi.chunk.TokenShapeChunker;
import com.aliasi.chunk.TokenShapeDecoder;
import com.aliasi.chunk.TrainableEstimator;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.corpus.TagHandler;
import com.aliasi.tokenizer.TokenCategorizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainTokenShapeChunker
implements TagHandler,
ObjectHandler<Chunking>,
Compilable {
    private final int mKnownMinTokenCount;
    private final int mMinTokenCount;
    private final int mMinTagCount;
    private final TokenCategorizer mTokenCategorizer;
    private final TokenizerFactory mTokenizerFactory;
    private final TrainableEstimator mTrainableEstimator;
    private final List<String> mTokenList = new ArrayList<String>();
    private final List<String> mTagList = new ArrayList<String>();

    public TrainTokenShapeChunker(TokenCategorizer categorizer, TokenizerFactory factory) {
        this(categorizer, factory, 8, 1, 1);
    }

    public TrainTokenShapeChunker(TokenCategorizer categorizer, TokenizerFactory factory, int knownMinTokenCount, int minTokenCount, int minTagCount) {
        this.mTokenCategorizer = categorizer;
        this.mTokenizerFactory = factory;
        this.mKnownMinTokenCount = knownMinTokenCount;
        this.mMinTokenCount = minTokenCount;
        this.mMinTagCount = minTagCount;
        this.mTrainableEstimator = new TrainableEstimator(categorizer);
    }

    @Override
    @Deprecated
    public void handle(String[] tokens, String[] whitespaces, String[] tags) {
        if (tokens.length != tags.length) {
            String msg = "Tokens and tags must be same length. Found tokens.length=" + tokens.length + " tags.length=" + tags.length;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == null || tags[i] == null) {
                String msg = "Tags and tokens must not be null. Found tokens[" + i + "]=" + tokens[i] + " tags[" + i + "]=" + tags[i];
                throw new NullPointerException(msg);
            }
            this.mTokenList.add(tokens[i]);
            this.mTagList.add(tags[i]);
        }
    }

    @Override
    public void handle(Chunking chunking) {
        ChunkHandlerAdapter2 handler = new ChunkHandlerAdapter2(this, this.mTokenizerFactory, false);
        handler.handle(chunking);
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    void replaceUnknownsWithCategories(String[] tokens) {
        int i;
        ObjectToCounterMap<String> counter = new ObjectToCounterMap<String>();
        for (i = 0; i < tokens.length; ++i) {
            counter.increment(tokens[i]);
        }
        for (i = 0; i < tokens.length; ++i) {
            if (counter.getCount(tokens[i]) >= this.mKnownMinTokenCount) continue;
            tokens[i] = this.mTokenCategorizer.categorize(tokens[i]);
        }
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 142720610674437597L;
        final TrainTokenShapeChunker mChunker;

        public Externalizer() {
            this(null);
        }

        public Externalizer(TrainTokenShapeChunker chunker) {
            this.mChunker = chunker;
        }

        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            TokenizerFactory factory = (TokenizerFactory)in.readObject();
            TokenCategorizer categorizer = (TokenCategorizer)in.readObject();
            CompiledEstimator estimator = (CompiledEstimator)in.readObject();
            TokenShapeDecoder decoder = new TokenShapeDecoder(estimator, categorizer, 1000.0);
            return new TokenShapeChunker(factory, decoder);
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            int len = this.mChunker.mTagList.size();
            String[] tokens = this.mChunker.mTokenList.toArray(Strings.EMPTY_STRING_ARRAY);
            String[] tags = this.mChunker.mTagList.toArray(Strings.EMPTY_STRING_ARRAY);
            this.mChunker.mTrainableEstimator.handle(tokens, tags);
            this.mChunker.replaceUnknownsWithCategories(tokens);
            this.mChunker.mTrainableEstimator.handle(tokens, tags);
            this.mChunker.mTrainableEstimator.prune(this.mChunker.mMinTagCount, this.mChunker.mMinTokenCount);
            this.mChunker.mTrainableEstimator.smoothTags(1);
            AbstractExternalizable.compileOrSerialize(this.mChunker.mTokenizerFactory, objOut);
            AbstractExternalizable.compileOrSerialize(this.mChunker.mTokenCategorizer, objOut);
            this.mChunker.mTrainableEstimator.compileTo(objOut);
        }
    }
}

