/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNodeLabel;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

public class NormilizeFragmentCounts {
    File fragmentsFile;
    File outputFile;
    Hashtable<TSNodeLabel, double[]> fragmentsCounts;
    Hashtable<String, double[]> rootsCounts;

    public NormilizeFragmentCounts(File fragmentsFile, File outputFile) throws Exception {
        this.fragmentsFile = fragmentsFile;
        this.outputFile = outputFile;
        this.rootsCounts = new Hashtable();
        this.run();
    }

    private void run() throws Exception {
        this.getRootCounts();
        this.printFragments();
    }

    private void getRootCounts() throws Exception {
        Parameters.reportLine("Reading fragments from file: " + this.fragmentsFile);
        PrintProgress progress = new PrintProgress("Progress:", 10000, 0);
        Scanner fragmentsScanner = FileUtil.getScanner(this.fragmentsFile);
        while (fragmentsScanner.hasNextLine()) {
            progress.next();
            String line = fragmentsScanner.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
            double count = Double.parseDouble(lineSplit[1]);
            String root = fragment.label();
            Utility.increaseInTableDoubleArray(this.rootsCounts, root, count);
        }
        progress.end();
    }

    public void printFragments() throws Exception {
        Parameters.reportLine("Printing fragments to file: " + this.outputFile);
        PrintProgress progress = new PrintProgress("Progress:", 10000, 0);
        PrintWriter pw = FileUtil.getPrintWriter(this.outputFile);
        Scanner fragmentsScanner = FileUtil.getScanner(this.fragmentsFile);
        while (fragmentsScanner.hasNextLine()) {
            progress.next();
            String line = fragmentsScanner.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
            double count = Double.parseDouble(lineSplit[1]);
            String root = fragment.label();
            double rootCount = this.rootsCounts.get(root)[0];
            double relativeFreq = count / rootCount;
            pw.println(String.valueOf(fragment.toString(false, true)) + "\t" + relativeFreq);
        }
        pw.close();
        progress.end();
    }

    public static void main(String[] args) throws Exception {
        File fragmentsFile = new File(args[0]);
        File outputFile = new File(args[1]);
        new NormilizeFragmentCounts(fragmentsFile, outputFile);
    }
}

