def find_icd10_values(d):
    if isinstance(d, dict):
        for key, value in d.items():
            if key in ['icd-10', 'icd10', 'idc-10', 'idc10']:
                yield value  # 返回找到的值
            else:
                yield from find_icd10_values(value)  # 递归查找嵌套字典中的值
    elif isinstance(d, list):
        for item in d:
            yield from find_icd10_values(item)  # 递归查找嵌套列表中的值
