/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.alg.dense.misc.PermuteArray;
import org.ejml.alg.dense.misc.UnrolledDeterminantFromMinor;
import org.ejml.data.DenseMatrix64F;

public class NaiveDeterminant {
    public static double leibniz(DenseMatrix64F mat) {
        PermuteArray perm = new PermuteArray(mat.numCols);
        double total = 0.0;
        int[] p = perm.next();
        while (p != null) {
            double prod = 1.0;
            for (int i = 0; i < mat.numRows; ++i) {
                prod *= mat.get(i, p[i]);
            }
            total += (double)perm.sgn() * prod;
            p = perm.next();
        }
        return total;
    }

    public static double recursive(DenseMatrix64F mat) {
        if (mat.numRows == 1) {
            return mat.get(0);
        }
        if (mat.numRows == 2) {
            return mat.get(0) * mat.get(3) - mat.get(1) * mat.get(2);
        }
        if (mat.numRows == 3) {
            return UnrolledDeterminantFromMinor.det3(mat);
        }
        double result = 0.0;
        for (int i = 0; i < mat.numRows; ++i) {
            DenseMatrix64F minorMat = new DenseMatrix64F(mat.numRows - 1, mat.numRows - 1);
            for (int j = 1; j < mat.numRows; ++j) {
                for (int k = 0; k < mat.numRows; ++k) {
                    if (k < i) {
                        minorMat.set(j - 1, k, mat.get(j, k));
                        continue;
                    }
                    if (k <= i) continue;
                    minorMat.set(j - 1, k - 1, mat.get(j, k));
                }
            }
            if (i % 2 == 0) {
                result += mat.get(0, i) * NaiveDeterminant.recursive(minorMat);
                continue;
            }
            result -= mat.get(0, i) * NaiveDeterminant.recursive(minorMat);
        }
        return result;
    }
}

