import myutils
import os

def conv(score):
    if type(score) == float:
        return '{:.4f}'.format(score)
    else:
        return ''

def load(name):
    data = open('results/' + name + '.csv').readlines()
    treebanks = [x.split('\t')[0] for x in data]
    scores = [x.strip().split('\t')[1] for x in data]
    return treebanks, scores
import copy

def boldHighest(row, start):
    row = copy.deepcopy(row)
    maxScore = max([float(x) for x in row[start:]])
    for i in range(start,len(row)):
        if float(row[i]) == maxScore:
            row[i] = '\\textbf{' + row[i] + '}'
    return row

def getSize(path):
    counter = 0
    if os.path.isfile(path):
        for line in open(path):
            if len(line) > 3 and line[0] != '#':
                counter += 1
    return counter
scriptFinder = myutils.ScriptFinder()

def makeTable(task, lm):
    print()
    print(lm, task)
    names = ['single-task', 'multi-task', 'multi-task+split', 'multi-task+split+attention', 'multi-ling', 'multi-ling+split']
    if task != 'Tokens':
        names = names[1:]
    data = []
    for nameIdx, name in enumerate(names):
        treebanks, scores = load(task + '.' + name + '-' + lm + '-2.10')
        if nameIdx == 0:
            for score, treebank in zip(scores, treebanks):
                #if 'Sign' in treebank:
                #    score='0.0'
                data.append([treebank.replace('_', '\\_')])
                if task == 'Tokens':
                    train, dev, test = myutils.getTrainDevTest('data/ud-treebanks-v2.10.singleToken/' + treebank)
                    script = scriptFinder.guess_script('\n'.join(open(test.replace('conllu', 'txt')).readlines()[:100]))
                    data[-1].extend([str(getSize(train)), str(getSize(dev)), script])
                data[-1].append(score)
        else:
            if name == 'rulebased':
                print(scores, task + '.' + name + '-' + lm + '-2.10')
            for i in range(len(scores)):
                #if 'Sign' in treebanks[i]:
                #    score='0.0'
                if scores[i] == '---':
                    data[i].append(data[i][-1])
                else:
                    data[i].append(scores[i])
    totals = [0.0] * len(data[0])
    print(' & '.join(['Treebank'] + names) + ' \\\\')
    for row in data:
        if task == 'Tokens':
            print(' & '.join(boldHighest(row, 4)) + ' \\\\')
        else:
            print(' & '.join(boldHighest(row, 1)) + ' \\\\')
        for i in range(1,len(row)):
            try:
                totals[i] += float(row[i])
            except:
                pass
        
    row = ['Average'] + [conv(x/len(data)) for x in totals[1:]] 
    print(' & '.join(boldHighest(row, 1)) + ' \\\\')

for lm in myutils.mlms[:1]:
    for task in ['Tokens']:#, 'LAS', 'UPOS', 'UFeats', 'Lemmas']:
        makeTable(task, lm)

