/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;

public class SemiSupervisedLogConditionalObjectiveFunction
extends AbstractCachingDiffFunction {
    AbstractCachingDiffFunction objFunc;
    AbstractCachingDiffFunction biasedObjFunc;
    double convexComboFrac = 0.5;
    LogPrior prior;

    public void setPrior(LogPrior prior) {
        this.prior = prior;
    }

    @Override
    public int domainDimension() {
        return this.objFunc.domainDimension();
    }

    @Override
    protected void calculate(double[] x) {
        if (this.derivative == null) {
            this.derivative = new double[this.domainDimension()];
        }
        this.value = this.convexComboFrac * this.objFunc.valueAt(x) + (1.0 - this.convexComboFrac) * this.biasedObjFunc.valueAt(x);
        double[] d1 = this.objFunc.derivativeAt(x);
        double[] d2 = this.biasedObjFunc.derivativeAt(x);
        for (int i = 0; i < this.domainDimension(); ++i) {
            this.derivative[i] = this.convexComboFrac * d1[i] + (1.0 - this.convexComboFrac) * d2[i];
        }
        if (this.prior != null) {
            this.value += this.prior.compute(x, this.derivative);
        }
    }

    public SemiSupervisedLogConditionalObjectiveFunction(AbstractCachingDiffFunction objFunc, AbstractCachingDiffFunction biasedObjFunc, LogPrior prior, double convexComboFrac) {
        this.objFunc = objFunc;
        this.biasedObjFunc = biasedObjFunc;
        this.prior = prior;
        this.convexComboFrac = convexComboFrac;
        if (convexComboFrac < 0.0 || convexComboFrac > 1.0) {
            throw new RuntimeException("convexComboFrac has to lie between 0 and 1 (both inclusive).");
        }
    }

    public SemiSupervisedLogConditionalObjectiveFunction(AbstractCachingDiffFunction objFunc, AbstractCachingDiffFunction biasedObjFunc, LogPrior prior) {
        this(objFunc, biasedObjFunc, prior, 0.5);
    }
}

