# ssc, Sound Shape Code, 音形码
基于“音形码”的中文字符串相似度计算方法

1. 音形码的思路来源于我看的这篇博客：https://blog.csdn.net/chndata/article/details/41114771 ，我对其中的思路进行了实现和优化。我自己写了一点大致的编码过程的图解示例放在文档src/图解.docx中可供大家查看，其中包含了最后运行代码时的截图效果。

2. 代码的入口是目录src/soundshapescode/__init__.py，里面演示了如何使用这部分代码，测试用例是在字符串“国我爱你女生于无娃哇紫狼路爽晕约紫薇路又刘页列而紫粮路掩连哟罗”中寻找“紫琅路”的相近词（依据音形码）最后的结果是“紫狼路”和“紫粮路”。

3. 相似度的阈值我目前给的是SIMILARITY_THRESHOLD = 0.8，可在上面提到的__init__.py中看到，大家使用时可进行调整；另外SSC_ENCODE_WAY指的是编码方式，他有3种取值：'ALL','SOUND','SHAPE'，分别表示计算相似度时既考虑音又考虑形（代码中权重各占0.5，可调整）、或者只考虑音、或者只考虑形。

4. four_corner/用来处理汉字的四角编码，ssc_similarity/主要处理计算相似度，包含各编码位的权重等等（可自行调整权重大小），variant_kmp/是使用模式匹配算法KMP来处理字符串的比较，方法会返回模式串与主串的比较结果在满足要求的情况下的主串的下标，ssc.py里主要是如何进行编码的一些实现。

5. src/zh_data/文件夹下有几个文件：

（1）hanzi_ssc_res.txt是我收集的一个中文字库，然后运用本方法对所有汉字预先做的一个音形码的编码，大家如果对权重没有改变的话，可以直接使用这个文件，每一行是汉字以及汉字对应的音形码；如果权重想要自己调整的，就直接使用代码，而忽略掉这个文件

（2）unihan_structure.txt是汉字和该汉字的结构形状（例如上下结构、左右结构等）的一个映射文件

（3）utf8_strokes.txt是汉字和该汉字的笔画数的映射文件

6. 我的运行环境是：Python3.7
