theory question_42_6
imports Main

begin

typedecl entity
typedecl event

consts
  Theropods :: "entity ⇒ bool"
  Dromaeosaurs :: "entity ⇒ bool"
  Birds :: "entity ⇒ bool"
  Evolved :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Theropods, the group of bipedal dinosaurs that includes Dromaeosaurs, evolved into birds. *)
axiomatization where
  explanation_1: "∀x. Theropods x ⟶ (∃e. Evolved e ∧ Agent e x ∧ Patient e {y. Birds y})"

(* Explanation 2: The group of bipedal dinosaurs that includes Dromaeosaurs is a subset of Theropods. *)
axiomatization where
  explanation_2: "∀x. Dromaeosaurs x ⟶ Theropods x"

(* Explanation 3: Birds are a type of Theropods. *)
axiomatization where
  explanation_3: "∀x. Birds x ⟶ Theropods x"

theorem hypothesis:
  assumes asm: "Dromaeosaurs x"
  (* Hypothesis: The group of bipedal dinosaurs that included Dromaeosaurs eventually evolved into birds. *)
  shows "∃e. Evolved e ∧ Agent e x ∧ Patient e {y. Birds y}"
proof -
  from asm have "Theropods x" using explanation_2 by blast
  then have "∃e. Evolved e ∧ Agent e x ∧ Patient e {y. Birds y}" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
