theory question_16_9

imports Main

begin

typedecl entity
typedecl event

consts
  Virus :: "entity ⇒ bool"
  Envelope :: "entity ⇒ bool"
  Component :: "entity ⇒ entity ⇒ bool"
  Phospholipids :: "entity ⇒ bool"
  Includes :: "entity ⇒ entity ⇒ bool"
  Have :: "entity ⇒ entity ⇒ bool"
  Acts :: "entity ⇒ event ⇒ bool"
  Coating :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  ComposedOf :: "entity ⇒ entity ⇒ bool"
  Crucial :: "entity ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Virus x ∧  Coating c ∧ Phospholipids c ∧ Have x c "
  (* Hypothesis: Some viruses have a coating of phospholipids. *)
  shows "∃x c. Virus x ∧ Coating c ∧ Phospholipids c ∧ Have x c"
proof -
  from asm have "Virus x ∧ Coating c ∧ Phospholipids c ∧ Have x c" by simp
  then show ?thesis by simp
qed

end
