theory question_90_4
imports Main

begin

typedecl entity
typedecl event

consts
  Worker :: "entity ⇒ bool"
  BentOver :: "event ⇒ bool"
  BentPosition :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Pulling :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation: Three workers bent over pulling grass. *)
axiomatization where
  explanation: "∀x y z e1 e2. Worker x ∧ Worker y ∧ Worker z ⟶ (∃e2. BentOver e2 ∧ Agent e2 x ∧ Agent e2 y ∧ Agent e2 z ∧ (∃e1. Grass e1 ∧ Patient e1 x ∧ Patient e1 y ∧ Patient e1 z ∧ Pulling e1))"

theorem hypothesis:
  (* Premise: Three workers bent over pulling grass. *)
  assumes asm: "Worker x ∧ Worker y ∧ Worker z ∧ Grass e1 ∧ BentOver e2 ∧ Agent e2 x ∧ Agent e2 y ∧ Agent e2 z ∧ Patient e1 x ∧ Patient e1 y ∧ Patient e1 z ∧ Pulling e1"
  (* Hypothesis: Three workers bent over. *)
  shows "∃e. BentOver e ∧ Agent e x ∧ Agent e y ∧ Agent e z"
proof -
  from asm have "Worker x ∧ Worker y ∧ Worker z ∧ BentOver e2 ∧ Agent e2 x ∧ Agent e2 y ∧ Agent e2 z ∧ (∃e1. Grass e1 ∧ Patient e1 x ∧ Patient e1 y ∧ Patient e1 z ∧ Pulling e1)" by blast
  then have "Worker x ∧ Worker y ∧ Worker z ∧ BentOver e2 ∧ Agent e2 x ∧ Agent e2 y ∧ Agent e2 z" using explanation by blast
  then show ?thesis by blast
qed

end
