theory question_86_1

imports Main

begin

typedecl entity
typedecl event

consts
  Women :: "entity ⇒ bool"
  Talking :: "event ⇒ bool"
  Three :: "entity ⇒ bool"
  Table :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  Drinks :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"
  Conversing :: "event ⇒ bool"

(* Explanation: If there are women, then they can talk. *)
axiomatization where
  explanation: "∀x. Women x ⟶ (∃e. Talking e ∧ Agent e x)"

theorem hypothesis:
  (* Premise: There are three woman conversing at a table with drinks. *)
  assumes asm: "Women x ∧ Three y ∧ Table z ∧ At x z ∧ Drinks u ∧ With x u ∧  Conversing e ∧ Agent e x "
  (* Hypothesis: Women are talking. *)
  shows "∃x. Women x ∧ Talking e ∧ Agent e x"
proof -
  from asm have "Women x" by blast
  then have "∃e. Talking e ∧ Agent e x" using explanation by blast
  then show ?thesis using asm by blast
qed

end
