theory question_2_1
imports Main

begin

typedecl entity
typedecl event

consts
  Group :: "entity ⇒ bool"
  Participants :: "entity ⇒ entity ⇒ bool"
  Numbered :: "entity ⇒ bool"
  Together :: "bool ⇒ bool"
  Walks :: "event ⇒ bool"
  Street :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Path :: "event ⇒ entity ⇒ bool"

(* Premise: A group of numbered participants walk down the street together. *)
  axiomatization where
    premise_1: "Group g ∧ Participants p g ∧ Numbered p ∧ Street s ∧ Together t ∧ Walks e ∧ Agent e g ∧ Path e s"

theorem hypothesis:
  assumes asm: "premise_1"
  shows "∃x y e. Group x ∧ Street y ∧ Walks e ∧ Agent e x ∧ Path e y"
proof -
  from asm have "Group g ∧ Street s ∧ Walks e ∧ Agent e g ∧ Path e s" using premise_1 by blast
  then show ?thesis by blast
qed

end
