theory question_13_8
imports Main

begin

typedecl entity
typedecl event

consts
  WeekendBarbecue :: "event ⇒ bool"
  Food :: "entity ⇒ bool"
  Fish :: "entity ⇒ bool"
  IncludedIn :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A weekend barbecue can include fish as an instance of food. *)
axiomatization where
  explanation_1: "∀e. WeekendBarbecue e ⟶ (∃f. Food f ∧ Fish f ∧ IncludedIn f e)"

(* Explanation 2: The event includes some fish. *)
axiomatization where
  explanation_2: "∀e. WeekendBarbecue e ⟶ (∃f. Fish f ∧ IncludedIn f e)"

theorem hypothesis:
  (* Premise: Weekend barbecue with some fish. *)
  assumes asm: "WeekendBarbecue e ∧ Fish e"
  (* Hypothesis: Weekend barbecue with some fish *)
  shows "∃e. WeekendBarbecue e ∧ Fish e"
proof -
  from asm have "WeekendBarbecue e" by blast
  from asm have "Fish e" by blast
  then show ?thesis using asm by blast
qed

end
